/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.client;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiIngame;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ChatType;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.smileycorp.hordes.common.ConfigHandler;
import net.smileycorp.hordes.infection.CureEntityMessage;

public class ClientHandler {
    public static void playHordeSound(Vec3d dir, ResourceLocation sound) {
        if (ConfigHandler.hordeSpawnSound) {
            Minecraft mc = Minecraft.func_71410_x();
            WorldClient world = mc.field_71441_e;
            EntityPlayerSP player = mc.field_71439_g;
            BlockPos pos = new BlockPos(player.field_70165_t + 5.0 * dir.field_72450_a, player.field_70163_u, player.field_70161_v + 5.0 * dir.field_72449_c);
            float pitch = 1 + (world.field_73012_v.nextInt(6) - 3) / 10;
            world.func_184133_a((EntityPlayer)player, pos, new SoundEvent(sound), SoundCategory.HOSTILE, 0.3f, pitch);
        }
    }

    public static EntityPlayer getPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public static void displayMessage(String text) {
        GuiIngame gui = Minecraft.func_71410_x().field_71456_v;
        TextComponentTranslation message = new TextComponentTranslation(text, new Object[0]);
        message.func_150255_a(new Style().func_150227_a(Boolean.valueOf(true)).func_150238_a(TextFormatting.DARK_RED));
        if (ConfigHandler.eventNotifyMode == 1) {
            gui.func_191742_a(ChatType.CHAT, (ITextComponent)message);
        } else if (ConfigHandler.eventNotifyMode == 2) {
            gui.field_73838_g = message.func_150254_d();
            gui.field_73845_h = ConfigHandler.eventNotifyDuration;
            gui.field_73844_j = false;
        } else if (ConfigHandler.eventNotifyMode == 3) {
            gui.func_175178_a(null, null, 5, ConfigHandler.eventNotifyDuration, 5);
            gui.func_175178_a(" ", null, 0, 0, 0);
            gui.func_175178_a(null, message.func_150254_d(), 0, 0, 0);
        }
    }

    public static void onInfect() {
        if (ConfigHandler.playerInfectSound) {
            Minecraft mc = Minecraft.func_71410_x();
            WorldClient world = mc.field_71441_e;
            EntityPlayerSP player = mc.field_71439_g;
            world.func_184133_a((EntityPlayer)player, player.func_180425_c(), SoundEvents.field_187941_ho, SoundCategory.HOSTILE, 0.75f, world.field_73012_v.nextFloat());
        }
    }

    public static void processCureEntityMessage(CureEntityMessage message) {
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient world = mc.field_71441_e;
        Entity entity = message.getEntity((World)world);
        world.func_184134_a(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, SoundEvents.field_187604_bf, entity.func_184176_by(), 1.0f, 1.0f, true);
        Random rand = world.field_73012_v;
        for (int i = 0; i < 10; ++i) {
            world.func_175688_a(EnumParticleTypes.VILLAGER_HAPPY, entity.field_70165_t + (rand.nextDouble() - 0.5) * (double)entity.field_70130_N * 1.5, entity.field_70163_u + rand.nextDouble() * (double)entity.field_70131_O, entity.field_70161_v + (rand.nextDouble() - 0.5) * (double)entity.field_70130_N * 1.5, 0.0, 0.3, 0.0, new int[0]);
        }
    }
}

