/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common;

import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.smileycorp.hordes.common.ConfigHandler;
import net.smileycorp.hordes.common.IZombifyPlayer;
import net.smileycorp.hordes.common.MiscEventHandler;
import net.smileycorp.hordes.common.hordeevent.HordeEventHandler;
import net.smileycorp.hordes.common.hordeevent.HordeEventPacketHandler;
import net.smileycorp.hordes.common.hordeevent.HordeEventRegister;
import net.smileycorp.hordes.common.hordeevent.IHordeSpawn;
import net.smileycorp.hordes.common.hordeevent.IOngoingHordeEvent;
import net.smileycorp.hordes.common.hordeevent.OngoingHordeEvent;
import net.smileycorp.hordes.common.hordeevent.command.CommandDebugHordeEvent;
import net.smileycorp.hordes.common.hordeevent.command.CommandSpawnWave;
import net.smileycorp.hordes.common.hordeevent.command.CommandStartHordeEvent;
import net.smileycorp.hordes.common.hordeevent.command.CommandStopHordeEvent;
import net.smileycorp.hordes.infection.InfectionEventHandler;
import net.smileycorp.hordes.infection.InfectionPacketHandler;
import net.smileycorp.hordes.infection.InfectionRegister;

public class CommonProxy {
    public void preInit(FMLPreInitializationEvent event) {
        ConfigHandler.config = new Configuration(event.getSuggestedConfigurationFile());
        ConfigHandler.syncConfig();
        MinecraftForge.EVENT_BUS.register((Object)this);
        CapabilityManager.INSTANCE.register(IZombifyPlayer.class, (Capability.IStorage)new IZombifyPlayer.Storage(), () -> new IZombifyPlayer.Implementation());
        CapabilityManager.INSTANCE.register(IHordeSpawn.class, (Capability.IStorage)new IHordeSpawn.Storage(), () -> new IHordeSpawn.HordeSpawn());
        CapabilityManager.INSTANCE.register(IOngoingHordeEvent.class, (Capability.IStorage)new IOngoingHordeEvent.Storage(), () -> new OngoingHordeEvent());
        if (ConfigHandler.enableHordeEvent) {
            HordeEventPacketHandler.initPackets();
            MinecraftForge.EVENT_BUS.register((Object)new HordeEventHandler());
        } else {
            MinecraftForge.EVENT_BUS.unregister(HordeEventHandler.class);
        }
        if (ConfigHandler.enableMobInfection) {
            InfectionPacketHandler.initPackets();
            MinecraftForge.EVENT_BUS.register((Object)new InfectionEventHandler());
        } else {
            MinecraftForge.EVENT_BUS.unregister(InfectionEventHandler.class);
        }
        MinecraftForge.EVENT_BUS.register((Object)new MiscEventHandler());
    }

    public void init(FMLInitializationEvent event) {
    }

    public void postInit(FMLPostInitializationEvent event) {
        if (ConfigHandler.enableHordeEvent) {
            HordeEventRegister.readConfig();
        }
        if (ConfigHandler.enableMobInfection) {
            InfectionRegister.readConfig();
        }
    }

    public void serverStart(FMLServerStartingEvent event) {
        if (ConfigHandler.enableHordeEvent) {
            event.registerServerCommand((ICommand)new CommandSpawnWave());
            event.registerServerCommand((ICommand)new CommandStartHordeEvent());
            event.registerServerCommand((ICommand)new CommandStopHordeEvent());
            event.registerServerCommand((ICommand)new CommandDebugHordeEvent());
        }
    }
}

