/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.smileycorp.hordes.common.Hordes;
import net.smileycorp.hordes.common.entities.EntityZombiePlayer;

public interface IZombifyPlayer {
    public EntityZombiePlayer createZombie();

    public EntityZombiePlayer getZombie();

    public void clearZombie();

    public static class Provider
    implements ICapabilityProvider {
        protected final IZombifyPlayer instance;

        public Provider(EntityPlayer player) {
            this.instance = new Implementation(player);
        }

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == Hordes.ZOMBIFY_PLAYER;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            return (T)(capability == Hordes.ZOMBIFY_PLAYER ? Hordes.ZOMBIFY_PLAYER.cast((Object)this.instance) : null);
        }
    }

    public static class Implementation
    implements IZombifyPlayer {
        private final EntityPlayer player;
        private EntityZombiePlayer zombie = null;

        public Implementation() {
            this.player = null;
        }

        public Implementation(EntityPlayer player) {
            this.player = player;
        }

        @Override
        public EntityZombiePlayer createZombie() {
            this.zombie = new EntityZombiePlayer(this.player);
            this.zombie.func_70107_b(this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v);
            this.zombie.field_70761_aq = this.player.field_70761_aq;
            return this.zombie;
        }

        @Override
        public EntityZombiePlayer getZombie() {
            return this.zombie;
        }

        @Override
        public void clearZombie() {
            this.zombie = null;
        }
    }

    public static class Storage
    implements Capability.IStorage<IZombifyPlayer> {
        public NBTBase writeNBT(Capability<IZombifyPlayer> capability, IZombifyPlayer instance, EnumFacing side) {
            return null;
        }

        public void readNBT(Capability<IZombifyPlayer> capability, IZombifyPlayer instance, EnumFacing side, NBTBase nbt) {
        }
    }
}

