/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.PlayerDropsEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.smileycorp.hordes.common.ConfigHandler;
import net.smileycorp.hordes.common.Hordes;
import net.smileycorp.hordes.common.IZombifyPlayer;
import net.smileycorp.hordes.common.ModDefinitions;
import net.smileycorp.hordes.common.entities.EntityZombiePlayer;
import net.smileycorp.hordes.infection.HordesInfection;

public class MiscEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDeath(LivingDeathEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        if (entity != null) {
            World world = entity.field_70170_p;
            if (!world.field_72995_K && entity instanceof EntityPlayer & !(entity instanceof FakePlayer) && (entity.func_70644_a(HordesInfection.INFECTED) && ConfigHandler.enableMobInfection || ConfigHandler.zombieGraves) && entity.hasCapability(Hordes.ZOMBIFY_PLAYER, null)) {
                ((IZombifyPlayer)entity.getCapability(Hordes.ZOMBIFY_PLAYER, null)).createZombie();
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onDrop(PlayerDropsEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player != null & !(player instanceof FakePlayer)) {
            IZombifyPlayer cap;
            EntityZombiePlayer zombie;
            World world = player.field_70170_p;
            if (!world.field_72995_K && (player.func_70644_a(HordesInfection.INFECTED) && ConfigHandler.enableMobInfection || ConfigHandler.zombieGraves) && player.hasCapability(Hordes.ZOMBIFY_PLAYER, null) && (zombie = (cap = (IZombifyPlayer)player.getCapability(Hordes.ZOMBIFY_PLAYER, null)).getZombie()) != null) {
                List drops = event.getDrops();
                zombie.setInventory(drops);
                zombie.func_110163_bv();
                world.func_72838_d((Entity)zombie);
                drops.clear();
                cap.clearZombie();
            }
        }
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (!entity.hasCapability(Hordes.HORDESPAWN, null) && entity instanceof EntityPlayer & !(entity instanceof FakePlayer)) {
            event.addCapability(ModDefinitions.getResource("Infection"), (ICapabilityProvider)new IZombifyPlayer.Provider((EntityPlayer)entity));
        }
    }
}

