/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.entities;

import com.google.common.base.Optional;
import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.UUID;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.scoreboard.ScorePlayerTeam;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.FMLCommonHandler;

public class EntityZombiePlayer
extends EntityZombie {
    protected static final DataParameter<Optional<UUID>> PLAYER_UUID = EntityDataManager.func_187226_a(EntityZombiePlayer.class, (DataSerializer)DataSerializers.field_187203_m);
    protected NonNullList<ItemStack> playerItems = NonNullList.func_191196_a();
    protected UUID uuid;

    public EntityZombiePlayer(World world) {
        super(world);
    }

    public EntityZombiePlayer(EntityPlayer player) {
        this(player.field_70170_p);
        this.setPlayer(player);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(PLAYER_UUID, (Object)Optional.of((Object)UUID.fromString("1512ce82-00e5-441a-9774-f46d9b7badfb")));
    }

    public void setPlayer(EntityPlayer player) {
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            ItemStack stack = slot.func_188453_a() == EntityEquipmentSlot.Type.ARMOR ? (ItemStack)player.field_71071_by.field_70460_b.get(slot.func_188454_b()) : (slot == EntityEquipmentSlot.MAINHAND ? player.func_184614_ca() : player.func_184592_cb());
            this.func_184201_a(slot, stack);
        }
        this.setPlayer(player.func_146103_bH());
    }

    public void setPlayer(String username) {
        this.setPlayer(FMLCommonHandler.instance().getMinecraftServerInstance().func_152358_ax().func_152655_a(username));
    }

    public void setPlayer(UUID uuid) {
        this.setPlayer(FMLCommonHandler.instance().getMinecraftServerInstance().func_152358_ax().func_152652_a(uuid));
    }

    public void setPlayer(GameProfile profile) {
        this.uuid = profile.getId();
        this.func_96094_a(profile.getName());
        this.field_70180_af.func_187227_b(PLAYER_UUID, (Object)Optional.of((Object)this.uuid));
    }

    public UUID getPlayerUUID() {
        return (UUID)((Optional)this.field_70180_af.func_187225_a(PLAYER_UUID)).get();
    }

    public void setInventory(List<EntityItem> list) {
        this.playerItems.clear();
        for (EntityItem item : list) {
            ItemStack stack = item.func_92059_d();
            item.func_70106_y();
            if (stack == null) continue;
            this.playerItems.add((Object)stack.func_77946_l());
        }
    }

    protected void func_82160_b(boolean recentlyHit, int looting) {
        for (ItemStack stack : this.playerItems) {
            if (stack.func_190926_b() || EnchantmentHelper.func_190939_c((ItemStack)stack)) continue;
            this.func_70099_a(stack, 0.0f);
        }
    }

    public boolean func_190730_o() {
        return false;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.uuid != null) {
            compound.func_74778_a("player", this.uuid.toString());
        }
        ItemStackHelper.func_191282_a((NBTTagCompound)compound, this.playerItems);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (compound.func_74764_b("player")) {
            this.uuid = UUID.fromString(compound.func_74779_i("player"));
        }
        NonNullList read = NonNullList.func_191197_a((int)compound.func_150295_c("Items", 10).func_74745_c(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)compound, (NonNullList)read);
        this.playerItems = read;
    }

    public ITextComponent func_145748_c_() {
        TextComponentTranslation textcomponentstring = new TextComponentTranslation(ScorePlayerTeam.func_96667_a((Team)this.func_96124_cp(), (String)"entity.hordes.ZombiePlayer.chat"), new Object[]{ScorePlayerTeam.func_96667_a((Team)this.func_96124_cp(), (String)this.func_70005_c_())});
        textcomponentstring.func_150256_b().func_150209_a(this.func_174823_aP());
        textcomponentstring.func_150256_b().func_179989_a(this.func_189512_bd());
        return textcomponentstring;
    }
}

