/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.hordeevent;

import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.smileycorp.atlas.api.entity.ai.EntityAIFindNearestTargetPredicate;
import net.smileycorp.atlas.api.entity.ai.EntityAIGoToEntityPos;
import net.smileycorp.atlas.api.util.DataUtils;
import net.smileycorp.hordes.common.ConfigHandler;
import net.smileycorp.hordes.common.Hordes;
import net.smileycorp.hordes.common.ModDefinitions;
import net.smileycorp.hordes.common.hordeevent.IHordeSpawn;
import net.smileycorp.hordes.common.hordeevent.IOngoingHordeEvent;
import net.smileycorp.hordes.common.hordeevent.WorldDataHordeEvent;

@Mod.EventBusSubscriber(modid="hordes")
public class HordeEventHandler {
    @SubscribeEvent
    public void worldTick(TickEvent.ServerTickEvent event) {
        MinecraftServer server;
        WorldServer world;
        if (event.phase == TickEvent.Phase.END && (world = (server = FMLCommonHandler.instance().getMinecraftServerInstance()).func_71218_a(0)).func_82736_K().func_82766_b("doDaylightCycle") | !ConfigHandler.pauseEventServer) {
            WorldDataHordeEvent data;
            int day = (int)Math.floor(world.func_72820_D() / (long)ConfigHandler.dayLength);
            if (day >= (data = WorldDataHordeEvent.getData((World)world)).getNextDay()) {
                data.setNextDay(world.field_73012_v.nextInt(ConfigHandler.hordeSpawnVariation + 1) + ConfigHandler.hordeSpawnDays + data.getNextDay());
            }
            data.save();
        }
    }

    @SubscribeEvent
    public void playerTick(TickEvent.PlayerTickEvent event) {
        EntityPlayer player = event.player;
        if (event.phase == TickEvent.Phase.END && player != null && !(player instanceof FakePlayer)) {
            World world = player.field_70170_p;
            if (!world.field_72995_K && world.func_82736_K().func_82766_b("doDaylightCycle") | !ConfigHandler.pauseEventServer && player.hasCapability(Hordes.HORDE_EVENT, null)) {
                IOngoingHordeEvent horde = (IOngoingHordeEvent)player.getCapability(Hordes.HORDE_EVENT, null);
                int day = (int)Math.floor(world.func_72820_D() / (long)ConfigHandler.dayLength);
                int time = Math.round(world.func_72820_D() % (long)ConfigHandler.dayLength);
                if (!(horde == null || horde.isActive(world) || time < ConfigHandler.hordeStartTime || day < horde.getNextDay() || day == 0 && !ConfigHandler.spawnFirstDay || horde.isActive(world))) {
                    horde.tryStartEvent(ConfigHandler.hordeSpawnDuration, false);
                }
                if (horde.isActive(world)) {
                    horde.update(world);
                }
            }
        }
    }

    @SubscribeEvent
    public void tryDespawn(LivingSpawnEvent.AllowDespawn event) {
        EntityPlayerMP player;
        String uuid;
        IHordeSpawn cap;
        World world = event.getWorld();
        EntityLivingBase entity = event.getEntityLiving();
        if (entity.hasCapability(Hordes.HORDESPAWN, null) && (cap = (IHordeSpawn)entity.getCapability(Hordes.HORDESPAWN, null)).isHordeSpawned() && DataUtils.isValidUUID((String)(uuid = cap.getPlayerUUID())) && (player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(UUID.fromString(uuid))) != null && player.hasCapability(Hordes.HORDE_EVENT, null) && ((IOngoingHordeEvent)player.getCapability(Hordes.HORDE_EVENT, null)).isActive(world)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onJoin(EntityJoinWorldEvent event) {
        IHordeSpawn cap;
        EntityLiving entity;
        World world = event.getWorld();
        if (!world.field_72995_K && event.getEntity() instanceof EntityLiving && (entity = (EntityLiving)event.getEntity()).hasCapability(Hordes.HORDESPAWN, null) && (cap = (IHordeSpawn)entity.getCapability(Hordes.HORDESPAWN, null)).isHordeSpawned() && DataUtils.isValidUUID((String)cap.getPlayerUUID())) {
            entity.field_70715_bh.field_75782_a.clear();
            if (entity instanceof EntityCreature) {
                entity.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)entity, true, new Class[0]));
                entity.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)entity, EntityPlayer.class, false));
            } else {
                entity.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIFindNearestTargetPredicate(entity, e -> e instanceof EntityPlayer));
            }
            String uuid = cap.getPlayerUUID();
            EntityPlayerMP player = FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(UUID.fromString(uuid));
            if (player != null && player.hasCapability(Hordes.HORDE_EVENT, null)) {
                IOngoingHordeEvent horde = (IOngoingHordeEvent)player.getCapability(Hordes.HORDE_EVENT, null);
                entity.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIGoToEntityPos(entity, (Entity)player));
                horde.registerEntity(entity);
            }
        }
    }

    @SubscribeEvent
    public void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (ConfigHandler.pauseEventServer) {
            for (WorldServer sworld : server.field_71305_c) {
                if (sworld.func_82736_K().func_82766_b("doDaylightCycle")) continue;
                sworld.func_82736_K().func_82764_b("doDaylightCycle", "true");
            }
        }
    }

    @SubscribeEvent
    public void playerLeave(PlayerEvent.PlayerLoggedOutEvent event) {
        MinecraftServer server;
        if (ConfigHandler.pauseEventServer && (server = FMLCommonHandler.instance().getMinecraftServerInstance()).func_184103_al().func_181057_v().isEmpty()) {
            for (WorldServer sworld : server.field_71305_c) {
                sworld.func_82736_K().func_82764_b("doDaylightCycle", "false");
            }
        }
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity == null) {
            return;
        }
        if (entity.field_70170_p == null) {
            return;
        }
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (!entity.hasCapability(Hordes.HORDESPAWN, null) && entity instanceof EntityLiving && !(entity instanceof EntityPlayer)) {
            event.addCapability(ModDefinitions.getResource("HordeSpawn"), (ICapabilityProvider)new IHordeSpawn.Provider());
        }
        if (!entity.hasCapability(Hordes.HORDE_EVENT, null) && entity instanceof EntityPlayer && !(entity instanceof FakePlayer)) {
            event.addCapability(ModDefinitions.getResource("HordeEvent"), (ICapabilityProvider)new IOngoingHordeEvent.Provider((EntityPlayer)entity));
        }
    }

    @SubscribeEvent
    public void trySleep(PlayerSleepInBedEvent event) {
        IOngoingHordeEvent horde;
        EntityPlayer player = event.getEntityPlayer();
        World world = player.field_70170_p;
        if (!ConfigHandler.canSleepDuringHorde && !world.field_72995_K && player.hasCapability(Hordes.HORDE_EVENT, null) && ((horde = (IOngoingHordeEvent)player.getCapability(Hordes.HORDE_EVENT, null)).isHordeDay(world) && world.field_73011_w.canSleepAt(player, event.getPos()) == WorldProvider.WorldSleepResult.ALLOW & !world.func_72935_r() || horde.isActive(world))) {
            event.setResult(EntityPlayer.SleepResult.OTHER_PROBLEM);
            player.func_145747_a((ITextComponent)new TextComponentTranslation("message.hordes.TrySleep", new Object[0]));
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void playerClone(PlayerEvent.Clone event) {
        EntityPlayer player = event.getEntityPlayer();
        EntityPlayer original = event.getOriginal();
        if (player != null && original != null & (!(player instanceof FakePlayer) && !(original instanceof FakePlayer)) && player.hasCapability(Hordes.HORDE_EVENT, null) && original.hasCapability(Hordes.HORDE_EVENT, null)) {
            IOngoingHordeEvent horde = (IOngoingHordeEvent)player.getCapability(Hordes.HORDE_EVENT, null);
            horde.readFromNBT(((IOngoingHordeEvent)original.getCapability(Hordes.HORDE_EVENT, null)).writeToNBT(new NBTTagCompound()));
            horde.setPlayer(player);
        }
    }
}

