/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.hordeevent;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.registries.GameData;
import net.smileycorp.atlas.api.recipe.WeightedOutputs;
import net.smileycorp.hordes.common.ConfigHandler;
import net.smileycorp.hordes.common.Hordes;
import net.smileycorp.hordes.common.hordeevent.HordeSpawnEntry;

public class HordeEventRegister {
    protected static List<HordeSpawnEntry> spawnlist = new ArrayList<HordeSpawnEntry>();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void readConfig() {
        Hordes.logInfo("Trying to read spawn table from config");
        if (ConfigHandler.hordeSpawnList == null) {
            Hordes.logError("Error reading config.", new NullPointerException("Spawn table has loaded as null"));
        } else if (ConfigHandler.hordeSpawnList.length <= 0) {
            Hordes.logError("Error reading config.", new Exception("Spawn table in config is empty"));
        }
        for (String name : ConfigHandler.hordeSpawnList) {
            try {
                Class clazz = null;
                int weight = 0;
                int minDay = 0;
                int maxDay = 0;
                NBTTagCompound nbt = null;
                if (name.contains(":")) {
                    String[] nameSplit = name.split("-");
                    if (nameSplit.length <= 1) throw new Exception("Entry " + name + " is not in the correct format");
                    if (nameSplit[0].contains("{")) {
                        String nbtstring = nameSplit[0].substring(nameSplit[0].indexOf("{"));
                        nameSplit[0] = nameSplit[0].substring(0, nameSplit[0].indexOf("{"));
                        nbt = HordeEventRegister.parseNBT(name, nbtstring);
                    }
                    ResourceLocation loc = new ResourceLocation(nameSplit[0]);
                    if (!GameData.getEntityRegistry().containsKey(loc)) throw new Exception("Entity " + name + " is not registered");
                    clazz = ((EntityEntry)GameData.getEntityRegistry().getValue(loc)).getEntityClass();
                    try {
                        weight = Integer.valueOf(nameSplit[1]);
                    }
                    catch (Exception e) {
                        throw new Exception("Entity " + name + " has weight value " + nameSplit[1] + " which is not a valid integer");
                    }
                    try {
                        minDay = Integer.valueOf(nameSplit[2]);
                    }
                    catch (Exception e) {
                        throw new Exception("Entity " + name + " has min day value " + nameSplit[2] + " which is not a valid integer");
                    }
                    if (nameSplit.length > 3) {
                        try {
                            maxDay = Integer.valueOf(nameSplit[3]);
                        }
                        catch (Exception e) {
                            throw new Exception("Entity " + name + " has max day value " + nameSplit[3] + " which is not a valid integer");
                        }
                    }
                }
                if (clazz == null) {
                    throw new Exception("Entry " + name + " is not in the correct format");
                }
                if (!EntityLiving.class.isAssignableFrom(clazz) || weight <= 0) throw new Exception("Entity " + name + " is not an instance of EntityLiving");
                HordeSpawnEntry entry = new HordeSpawnEntry(clazz, weight, minDay, maxDay);
                if (nbt != null) {
                    entry.setTagCompound(nbt);
                }
                spawnlist.add(entry);
                Hordes.logInfo("Loaded entity " + name + " as " + clazz.getName() + " with weight " + weight + ", min day " + minDay + " and max day " + maxDay);
            }
            catch (Exception e) {
                Hordes.logError("Error adding entity " + name + " " + e.getCause() + " " + e.getMessage(), e);
            }
        }
    }

    private static NBTTagCompound parseNBT(String name, String nbtstring) {
        NBTTagCompound nbt = null;
        try {
            NBTTagCompound parsed = JsonToNBT.func_180713_a((String)nbtstring);
            if (parsed == null) {
                throw new NullPointerException("Parsed NBT is null.");
            }
            nbt = parsed;
        }
        catch (Exception e) {
            Hordes.logError("Error parsing nbt for entity " + name + " " + e.getMessage(), e);
        }
        return nbt;
    }

    public static WeightedOutputs<HordeSpawnEntry> getSpawnTable(int day) {
        ArrayList<AbstractMap.SimpleEntry<HordeSpawnEntry, Integer>> spawnmap = new ArrayList<AbstractMap.SimpleEntry<HordeSpawnEntry, Integer>>();
        for (HordeSpawnEntry entry : spawnlist) {
            if (entry.getMinDay() > day || entry.getMaxDay() != 0 && entry.getMaxDay() < day) continue;
            spawnmap.add(new AbstractMap.SimpleEntry<HordeSpawnEntry, Integer>(entry, entry.getWeight()));
            Hordes.logInfo("Adding entry " + entry.toString() + " to hordespawn on day " + day);
        }
        return new WeightedOutputs(1, spawnmap);
    }

    public static List<HordeSpawnEntry> getEntriesFor(EntityLiving entity) {
        return HordeEventRegister.getEntriesFor(entity.getClass());
    }

    public static List<HordeSpawnEntry> getEntriesFor(Class<? extends EntityLiving> clazz) {
        ArrayList<HordeSpawnEntry> list = new ArrayList<HordeSpawnEntry>();
        for (HordeSpawnEntry entry : spawnlist) {
            if (entry.getEntity() != clazz) continue;
            list.add(entry);
        }
        return list;
    }

    public static HordeSpawnEntry getEntryFor(EntityLiving entity, int day) {
        for (HordeSpawnEntry entry : HordeEventRegister.getEntriesFor(entity)) {
            if (entry.getMinDay() > day || entry.getMaxDay() != 0 && entry.getMaxDay() < day) continue;
            return entry;
        }
        return null;
    }
}

