/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.hordeevent;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.smileycorp.hordes.common.Hordes;

public interface IHordeSpawn {
    public boolean isHordeSpawned();

    public void setPlayerUUID(String var1);

    public String getPlayerUUID();

    public static class Provider
    implements ICapabilitySerializable<NBTBase> {
        protected IHordeSpawn instance = (IHordeSpawn)Hordes.HORDESPAWN.getDefaultInstance();

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == Hordes.HORDESPAWN;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            return (T)(capability == Hordes.HORDESPAWN ? Hordes.HORDESPAWN.cast((Object)this.instance) : null);
        }

        public NBTBase serializeNBT() {
            return Hordes.HORDESPAWN.getStorage().writeNBT(Hordes.HORDESPAWN, (Object)this.instance, null);
        }

        public void deserializeNBT(NBTBase nbt) {
            Hordes.HORDESPAWN.getStorage().readNBT(Hordes.HORDESPAWN, (Object)this.instance, null, nbt);
        }
    }

    public static class HordeSpawn
    implements IHordeSpawn {
        private String uuid = "";

        @Override
        public boolean isHordeSpawned() {
            return !this.uuid.isEmpty();
        }

        @Override
        public void setPlayerUUID(String uuid) {
            this.uuid = uuid;
        }

        @Override
        public String getPlayerUUID() {
            return this.uuid;
        }
    }

    public static class Storage
    implements Capability.IStorage<IHordeSpawn> {
        public NBTBase writeNBT(Capability<IHordeSpawn> capability, IHordeSpawn instance, EnumFacing side) {
            return new NBTTagString(instance.getPlayerUUID());
        }

        public void readNBT(Capability<IHordeSpawn> capability, IHordeSpawn instance, EnumFacing side, NBTBase nbt) {
            instance.setPlayerUUID(((NBTTagString)nbt).func_150285_a_());
        }
    }
}

