/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.hordeevent;

import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.smileycorp.atlas.api.SimpleStringMessage;
import net.smileycorp.atlas.api.entity.ai.EntityAIFindNearestTargetPredicate;
import net.smileycorp.atlas.api.entity.ai.EntityAIGoToEntityPos;
import net.smileycorp.atlas.api.recipe.WeightedOutputs;
import net.smileycorp.atlas.api.util.DirectionUtils;
import net.smileycorp.hordes.common.ConfigHandler;
import net.smileycorp.hordes.common.Hordes;
import net.smileycorp.hordes.common.event.HordeBuildSpawntableEvent;
import net.smileycorp.hordes.common.event.HordeEndEvent;
import net.smileycorp.hordes.common.event.HordeSpawnEntityEvent;
import net.smileycorp.hordes.common.event.HordeStartEvent;
import net.smileycorp.hordes.common.event.HordeStartWaveEvent;
import net.smileycorp.hordes.common.hordeevent.HordeEventPacketHandler;
import net.smileycorp.hordes.common.hordeevent.HordeEventRegister;
import net.smileycorp.hordes.common.hordeevent.HordeSoundMessage;
import net.smileycorp.hordes.common.hordeevent.HordeSpawnEntry;
import net.smileycorp.hordes.common.hordeevent.IHordeSpawn;
import net.smileycorp.hordes.common.hordeevent.IOngoingHordeEvent;
import net.smileycorp.hordes.common.hordeevent.WorldDataHordeEvent;
import net.smileycorp.hordes.integration.mobspropertiesrandomness.MPRIntegration;
import org.apache.commons.lang3.ArrayUtils;

public class OngoingHordeEvent
implements IOngoingHordeEvent {
    private Set<WeakReference<EntityLiving>> entitiesSpawned = new HashSet<WeakReference<EntityLiving>>();
    private int timer = 0;
    private int day = 0;
    private int nextDay;
    private final World world;
    private EntityPlayer player;
    private boolean hasChanged = false;

    public OngoingHordeEvent(World world, EntityPlayer player) {
        this.world = world;
        this.player = player;
        if (world != null) {
            WorldDataHordeEvent data = WorldDataHordeEvent.getData(world);
            this.nextDay = data.getNextDay();
            if (data.hasLegacyData(player.func_110124_au())) {
                this.readFromNBT(data.getLegacyData(player.func_110124_au()));
            }
        }
    }

    public OngoingHordeEvent() {
        this.world = null;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.entitiesSpawned.clear();
        if (nbt.func_74764_b("timer")) {
            this.timer = nbt.func_74762_e("timer");
        }
        if (nbt.func_74764_b("nextDay")) {
            this.nextDay = nbt.func_74762_e("nextDay");
        }
        if (nbt.func_74764_b("day")) {
            this.day = nbt.func_74762_e("day");
        }
        if (nbt.func_74764_b("entities") && this.world != null) {
            for (int id : nbt.func_74759_k("entities")) {
                Entity entity = this.world.func_73045_a(id);
                if (!(entity instanceof EntityLiving)) continue;
                this.entitiesSpawned.add(new WeakReference<EntityLiving>((EntityLiving)entity));
            }
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("timer", this.timer);
        nbt.func_74768_a("nextDay", this.nextDay);
        nbt.func_74768_a("day", this.day);
        int[] entities = new int[]{};
        for (WeakReference<EntityLiving> ref : this.entitiesSpawned) {
            EntityLiving entity;
            if (ref == null || (entity = (EntityLiving)ref.get()) == null || !(entity.isAddedToWorld() & !entity.field_70128_L)) continue;
            ArrayUtils.add((int[])entities, (int)entity.func_145782_y());
        }
        nbt.func_74783_a("entities", entities);
        this.hasChanged = false;
        return nbt;
    }

    public void update(World world) {
        if (!world.field_72995_K && this.player != null && this.player.field_70170_p.field_73011_w.getDimension() == 0) {
            if (this.timer % ConfigHandler.hordeSpawnInterval == 0) {
                int amount = (int)((double)ConfigHandler.hordeSpawnAmount * (1.0 + (double)(this.day / ConfigHandler.hordeSpawnDays) * (ConfigHandler.hordeSpawnMultiplier - 1.0)));
                List players = world.func_175644_a(EntityPlayer.class, p -> p != this.player);
                for (EntityPlayer entity : players) {
                    if (!(this.player.func_70032_d((Entity)entity) <= 25.0f)) continue;
                    amount = (int)Math.floor((double)amount * ConfigHandler.hordeMultiplayerScaling);
                }
                this.spawnWave(world, amount);
            }
            --this.timer;
            if (this.timer == 0) {
                this.stopEvent(world, false);
            }
            this.hasChanged = true;
        }
    }

    @Override
    public void spawnWave(World world, int count) {
        this.cleanSpawns();
        HordeStartWaveEvent startEvent = new HordeStartWaveEvent(this.player, this, count);
        MinecraftForge.EVENT_BUS.post((Event)startEvent);
        if (startEvent.isCanceled()) {
            return;
        }
        count = startEvent.getCount();
        Vec3d basedir = DirectionUtils.getRandomDirectionVecXZ((Random)world.field_73012_v);
        BlockPos basepos = DirectionUtils.getClosestLoadedPos((World)world, (BlockPos)this.player.func_180425_c(), (Vec3d)basedir, (double)75.0, (int)7, (int)0);
        int i = 0;
        while (basepos.equals((Object)this.player.func_180425_c())) {
            basedir = DirectionUtils.getRandomDirectionVecXZ((Random)world.field_73012_v);
            basepos = DirectionUtils.getClosestLoadedPos((World)world, (BlockPos)this.player.func_180425_c(), (Vec3d)basedir, (double)75.0, (int)7, (int)0);
            if (++i != 20) continue;
            this.logInfo("Unable to find unlight pos ");
            basepos = DirectionUtils.getClosestLoadedPos((World)world, (BlockPos)this.player.func_180425_c(), (Vec3d)basedir, (double)75.0);
            break;
        }
        HordeBuildSpawntableEvent buildTableEvent = new HordeBuildSpawntableEvent(this.player, HordeEventRegister.getSpawnTable(this.day), this);
        MinecraftForge.EVENT_BUS.post((Event)buildTableEvent);
        WeightedOutputs<HordeSpawnEntry> spawntable = buildTableEvent.spawntable;
        if (spawntable.isEmpty()) {
            this.logInfo("Spawntable is empty, stopping wave spawn.");
            return;
        }
        if (count > 0) {
            if (this.player instanceof EntityPlayerMP) {
                HordeEventPacketHandler.NETWORK_INSTANCE.sendTo((IMessage)new HordeSoundMessage(basedir, startEvent.getSound()), (EntityPlayerMP)this.player);
            }
        } else {
            this.logInfo("Stopping wave spawn because count is " + count);
        }
        for (int n = 0; n < count; ++n) {
            if (this.entitiesSpawned.size() > ConfigHandler.hordeSpawnMax) {
                this.logInfo("Can't spawn wave because max cap has been reached");
                return;
            }
            Vec3d dir = DirectionUtils.getRandomDirectionVecXZ((Random)world.field_73012_v);
            BlockPos pos = DirectionUtils.getClosestLoadedPos((World)world, (BlockPos)basepos, (Vec3d)dir, (double)world.field_73012_v.nextInt(10));
            HordeSpawnEntry entry = (HordeSpawnEntry)spawntable.getResult(world.field_73012_v);
            Class<? extends EntityLiving> clazz = entry.getEntity();
            try {
                EntityLiving entity = clazz.getConstructor(World.class).newInstance(world);
                entity.func_70020_e(entry.getTagCompound());
                HordeSpawnEntityEvent spawnEntityEvent = new HordeSpawnEntityEvent(this.player, entity, pos, this);
                MinecraftForge.EVENT_BUS.post((Event)spawnEntityEvent);
                if (!spawnEntityEvent.isCanceled()) {
                    entity = spawnEntityEvent.entity;
                    pos = spawnEntityEvent.pos;
                    entity.func_180482_a(world.func_175649_E(pos), null);
                    entity.func_70107_b((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                    if (!world.func_72838_d((Entity)entity)) {
                        Hordes.logError("Unable to spawn entity from " + clazz, new Exception());
                    }
                    entity.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(100.0);
                    if (Loader.isModLoaded((String)"mpr")) {
                        MPRIntegration.addFollowAttribute(entity);
                    }
                    ((IHordeSpawn)entity.getCapability(Hordes.HORDESPAWN, null)).setPlayerUUID(this.player.func_110124_au().toString());
                    entity.func_110163_bv();
                    this.registerEntity(entity);
                    this.hasChanged = true;
                    entity.field_70715_bh.field_75782_a.clear();
                    if (entity instanceof EntityCreature) {
                        entity.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)entity, true, new Class[0]));
                        entity.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)entity, EntityPlayer.class, false));
                    } else {
                        entity.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIFindNearestTargetPredicate(entity, e -> e instanceof EntityPlayer));
                    }
                    entity.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIGoToEntityPos(entity, (Entity)this.player));
                    continue;
                }
                this.logInfo("Entity spawn event has been cancelled, not spawning entity  of class " + clazz);
                continue;
            }
            catch (Exception e2) {
                e2.printStackTrace();
                Hordes.logError("Unable to spawn entity from " + clazz, e2);
            }
        }
    }

    private void cleanSpawns() {
        ArrayList<WeakReference<EntityLiving>> toRemove = new ArrayList<WeakReference<EntityLiving>>();
        for (WeakReference<EntityLiving> ref : this.entitiesSpawned) {
            if (ref != null && ref.get() != null) {
                EntityLiving entity = (EntityLiving)ref.get();
                if (!entity.field_70128_L || !entity.hasCapability(Hordes.HORDESPAWN, null)) continue;
                IHordeSpawn cap = (IHordeSpawn)entity.getCapability(Hordes.HORDESPAWN, null);
                cap.setPlayerUUID("");
                toRemove.add(ref);
                continue;
            }
            toRemove.add(ref);
        }
        this.entitiesSpawned.removeAll(toRemove);
    }

    @Override
    public boolean isHordeDay(World world) {
        if (world.field_72995_K || this.player == null) {
            return false;
        }
        if (world != this.world) {
            return false;
        }
        return this.isActive(world) || Math.floor(world.func_72820_D() / (long)ConfigHandler.dayLength) >= (double)this.nextDay;
    }

    public boolean isActive(World world) {
        return this.timer > 0;
    }

    @Override
    public boolean hasChanged() {
        return this.hasChanged;
    }

    @Override
    public EntityPlayer getPlayer() {
        return this.player;
    }

    @Override
    public void setPlayer(EntityPlayer player) {
        this.player = player;
        HashSet<WeakReference<EntityLiving>> toRemove = new HashSet<WeakReference<EntityLiving>>();
        for (WeakReference<EntityLiving> ref : this.entitiesSpawned) {
            EntityLiving entity = (EntityLiving)ref.get();
            if (entity != null) {
                EntityAIGoToEntityPos task = null;
                for (EntityAITasks.EntityAITaskEntry entry : entity.field_70714_bg.field_75782_a) {
                    if (!(entry.field_75733_a instanceof EntityAIGoToEntityPos)) continue;
                    task = (EntityAIGoToEntityPos)entry.field_75733_a;
                    break;
                }
                if (task == null) continue;
                entity.field_70714_bg.func_85156_a(task);
                entity.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIGoToEntityPos(entity, (Entity)player));
                continue;
            }
            toRemove.add(ref);
        }
        this.entitiesSpawned.removeAll(toRemove);
        this.hasChanged = true;
    }

    @Override
    public void tryStartEvent(int duration, boolean isCommand) {
        if (this.player != null) {
            if (this.player.field_70170_p.field_73011_w.getDimension() == 0) {
                HordeStartEvent startEvent = new HordeStartEvent(this.player, this, isCommand);
                MinecraftForge.EVENT_BUS.post((Event)startEvent);
                if (startEvent.isCanceled()) {
                    return;
                }
                HordeBuildSpawntableEvent buildTableEvent = new HordeBuildSpawntableEvent(this.player, HordeEventRegister.getSpawnTable((int)Math.floor(this.world.func_72820_D() / (long)ConfigHandler.dayLength)), this);
                MinecraftForge.EVENT_BUS.post((Event)buildTableEvent);
                WeightedOutputs<HordeSpawnEntry> spawntable = buildTableEvent.spawntable;
                if (!spawntable.isEmpty()) {
                    this.timer = duration;
                    this.hasChanged = true;
                    this.sendMessage(startEvent.getMessage());
                    this.day = isCommand ? (int)Math.floor(this.world.func_72820_D() / (long)ConfigHandler.dayLength) : this.nextDay;
                } else {
                    this.logInfo("Spawntable is empty, canceling event start.");
                }
                if (!isCommand) {
                    this.nextDay = WorldDataHordeEvent.getData(this.world).getNextDay();
                }
            }
        } else {
            Hordes.logError("player is null for " + this.toString(), new NullPointerException());
        }
    }

    @Override
    public void setNextDay(int day) {
        this.nextDay = day;
    }

    @Override
    public int getNextDay() {
        return this.nextDay;
    }

    private void sendMessage(String str) {
        HordeEventPacketHandler.NETWORK_INSTANCE.sendTo((IMessage)new SimpleStringMessage(str), (EntityPlayerMP)this.player);
    }

    @Override
    public void stopEvent(World world, boolean isCommand) {
        HordeEndEvent endEvent = new HordeEndEvent(this.player, this, isCommand);
        MinecraftForge.EVENT_BUS.post((Event)endEvent);
        this.timer = 0;
        this.cleanSpawns();
        this.sendMessage(endEvent.getMessage());
        ArrayList<WeakReference<EntityLiving>> toRemove = new ArrayList<WeakReference<EntityLiving>>();
        for (WeakReference<EntityLiving> ref : this.entitiesSpawned) {
            EntityLiving entity = (EntityLiving)ref.get();
            if (!entity.hasCapability(Hordes.HORDESPAWN, null)) continue;
            IHordeSpawn cap = (IHordeSpawn)entity.getCapability(Hordes.HORDESPAWN, null);
            cap.setPlayerUUID("");
            toRemove.add(ref);
        }
        this.entitiesSpawned.removeAll(toRemove);
        this.hasChanged = true;
    }

    @Override
    public void removeEntity(EntityLiving entity) {
        this.entitiesSpawned.remove(entity);
    }

    @Override
    public void registerEntity(EntityLiving entity) {
        WeakReference<EntityLiving> ref = new WeakReference<EntityLiving>(entity);
        if (!this.entitiesSpawned.contains(ref)) {
            this.entitiesSpawned.add(ref);
        }
    }

    public String toString() {
        return "OngoingHordeEvent@" + Integer.toHexString(this.hashCode()) + "[player=" + (this.player == null ? "null" : this.player.func_70005_c_()) + ", isActive=" + (this.timer > 0) + ", ticksLeft=" + this.timer + ", entityCount=" + this.entitiesSpawned.size() + ", nextDay=" + this.nextDay + ", day=" + this.day + "]";
    }

    private void logInfo(Object message) {
        Hordes.logInfo("[" + this + "]" + message);
    }

    public List<String> getEntityStrings() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("\tentities: {");
        ArrayList<WeakReference<EntityLiving>> entitylist = new ArrayList<WeakReference<EntityLiving>>(this.entitiesSpawned);
        for (int i = 0; i < entitylist.size(); i += 10) {
            List sublist = entitylist.subList(i, Math.min(i + 9, entitylist.size() - 1));
            StringBuilder builder = new StringBuilder();
            builder.append("\t\t");
            for (WeakReference ref : sublist) {
                EntityLiving entity = (EntityLiving)ref.get();
                builder.append(entity.getClass().getSimpleName() + "@");
                builder.append(Integer.toHexString(entity.hashCode()));
                if (entitylist.indexOf(ref) >= entitylist.size() - 1) continue;
                builder.append(", ");
            }
            builder.append("}");
            result.add(builder.toString());
        }
        return result;
    }
}

