/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.hordeevent;

import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.smileycorp.atlas.api.util.DataUtils;
import net.smileycorp.hordes.common.ConfigHandler;
import net.smileycorp.hordes.common.Hordes;
import net.smileycorp.hordes.common.hordeevent.OngoingHordeEvent;

public class WorldDataHordeEvent
extends WorldSavedData {
    public static final String DATA = "hordes_HordeEvent";
    private Map<String, NBTTagCompound> legacyEventData = new HashMap<String, NBTTagCompound>();
    private int nextDay = 0;
    protected World world = null;

    public WorldDataHordeEvent() {
        this(DATA);
    }

    public WorldDataHordeEvent(String data) {
        super(data);
    }

    public void func_76184_a(NBTTagCompound nbt) {
        int next;
        this.legacyEventData.clear();
        for (String uuidstring : nbt.func_150296_c()) {
            if (nbt.func_150299_b(uuidstring) != 10 || !DataUtils.isValidUUID((String)uuidstring)) continue;
            this.legacyEventData.put(uuidstring, (NBTTagCompound)nbt.func_74781_a(uuidstring));
        }
        if (nbt.func_74764_b("nextDay") && (next = nbt.func_74762_e("nextDay")) > this.nextDay) {
            this.nextDay = next;
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        for (Map.Entry<String, NBTTagCompound> entry : this.legacyEventData.entrySet()) {
            nbt.func_74782_a(entry.getKey(), (NBTBase)entry.getValue());
        }
        nbt.func_74768_a("nextDay", this.nextDay);
        return nbt;
    }

    public int getNextDay() {
        return this.nextDay;
    }

    public void setNextDay(int nextDay) {
        this.nextDay = nextDay;
    }

    @Deprecated
    public Set<OngoingHordeEvent> getEvents() {
        HashSet<OngoingHordeEvent> events = new HashSet<OngoingHordeEvent>();
        if (!this.world.field_72995_K) {
            for (EntityPlayer player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
                if (!player.hasCapability(Hordes.HORDE_EVENT, null)) continue;
                events.add((OngoingHordeEvent)player.getCapability(Hordes.HORDE_EVENT, null));
            }
        }
        return events;
    }

    @Deprecated
    public OngoingHordeEvent getEventForPlayer(EntityPlayer player) {
        if (player.hasCapability(Hordes.HORDE_EVENT, null)) {
            return (OngoingHordeEvent)player.getCapability(Hordes.HORDE_EVENT, null);
        }
        return null;
    }

    @Deprecated
    public OngoingHordeEvent getEventForPlayer(GameProfile profile) {
        return this.getEventForPlayer(profile.getId());
    }

    @Deprecated
    public OngoingHordeEvent getEventForPlayer(String uuid) {
        if (DataUtils.isValidUUID((String)uuid)) {
            return this.getEventForPlayer(UUID.fromString(uuid));
        }
        return null;
    }

    @Deprecated
    public OngoingHordeEvent getEventForPlayer(UUID uuid) {
        if (this.world != null && !this.world.field_72995_K) {
            return this.getEventForPlayer((EntityPlayer)FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_177451_a(uuid));
        }
        return null;
    }

    public boolean hasLegacyData(UUID uuid) {
        return this.legacyEventData.containsKey(uuid.toString());
    }

    public NBTTagCompound getLegacyData(UUID uuid) {
        NBTTagCompound nbt = this.legacyEventData.get(uuid.toString());
        this.legacyEventData.remove(uuid.toString());
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        return nbt;
    }

    public void save() {
        this.func_76185_a();
    }

    public static WorldDataHordeEvent getData(World world) {
        WorldDataHordeEvent data = (WorldDataHordeEvent)world.func_175693_T().func_75742_a(WorldDataHordeEvent.class, DATA);
        if (data == null) {
            return WorldDataHordeEvent.getCleanData(world);
        }
        if (data.world == null) {
            data.world = world;
        }
        return data;
    }

    public static WorldDataHordeEvent getCleanData(World world) {
        WorldDataHordeEvent data = new WorldDataHordeEvent();
        data.world = world;
        int day = Math.round(world.func_72820_D() / (long)ConfigHandler.dayLength);
        double multiplier = Math.ceil(day / ConfigHandler.hordeSpawnDays);
        if (!ConfigHandler.spawnFirstDay || day != 0) {
            multiplier += 1.0;
        }
        int nextDay = (int)Math.floor(multiplier * (double)ConfigHandler.hordeSpawnDays + (double)world.field_73012_v.nextInt(ConfigHandler.hordeSpawnVariation + 1));
        data.setNextDay(nextDay);
        world.func_175693_T().func_75745_a(DATA, (WorldSavedData)data);
        data.save();
        return data;
    }

    public List<String> getDebugText() {
        ArrayList<String> out = new ArrayList<String>();
        out.add(this.toString());
        out.add("Existing events: {");
        for (OngoingHordeEvent event : this.getEvents()) {
            out.add("\t" + event.toString());
            out.addAll(event.getEntityStrings());
        }
        out.add("}");
        return out;
    }

    public String toString() {
        return super.toString() + "[worldTime: " + this.world.func_72820_D() + ", nextDay=" + this.nextDay + "]";
    }
}

