/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.infection;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityZombieVillager;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.smileycorp.atlas.api.SimpleStringMessage;
import net.smileycorp.atlas.api.util.DirectionUtils;
import net.smileycorp.hordes.common.ConfigHandler;
import net.smileycorp.hordes.common.event.InfectionDeathEvent;
import net.smileycorp.hordes.infection.HordesInfection;
import net.smileycorp.hordes.infection.InfectionPacketHandler;
import net.smileycorp.hordes.infection.InfectionRegister;

@Mod.EventBusSubscriber(modid="hordes")
public class InfectionEventHandler {
    @SubscribeEvent
    public void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        EntityPlayer player = event.player;
        if (player != null && player instanceof EntityPlayerMP) {
            InfectionPacketHandler.NETWORK_INSTANCE.sendTo((IMessage)new SimpleStringMessage(InfectionRegister.getCurePacketData()), (EntityPlayerMP)player);
        }
    }

    @SubscribeEvent
    public void onItemStackConsume(LivingEntityUseItemEvent.Finish event) {
        EntityLivingBase entity = event.getEntityLiving();
        ItemStack stack = event.getItem();
        if (entity.func_70644_a(HordesInfection.INFECTED) && InfectionRegister.isCure(stack)) {
            entity.func_184589_d(HordesInfection.INFECTED);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onItemUse(PlayerInteractEvent.RightClickItem event) {
        EntityLivingBase entity;
        ItemStack stack = event.getItemStack();
        RayTraceResult ray = DirectionUtils.getPlayerRayTrace((World)event.getWorld(), (EntityPlayer)event.getEntityPlayer(), (float)5.0f);
        if (ray != null && ray.field_72308_g instanceof EntityLivingBase && (entity = (EntityLivingBase)ray.field_72308_g).func_70644_a(HordesInfection.INFECTED) && InfectionRegister.isCure(stack)) {
            entity.func_184589_d(HordesInfection.INFECTED);
            event.setCanceled(true);
            event.setCancellationResult(EnumActionResult.FAIL);
        }
    }

    @SubscribeEvent
    public void onDamage(LivingDamageEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        Entity attacker = event.getSource().func_76364_f();
        World world = entity.field_70170_p;
        Random rand = world.field_73012_v;
        if (!world.field_72995_K && InfectionRegister.canCauseInfection(attacker) && !entity.func_70644_a(HordesInfection.INFECTED)) {
            int c;
            if (entity instanceof EntityPlayer && ConfigHandler.infectPlayers) {
                int c2 = rand.nextInt(100);
                if (c2 <= ConfigHandler.playerInfectChance) {
                    entity.func_70690_d(new PotionEffect(HordesInfection.INFECTED, 10000, 0));
                    InfectionPacketHandler.NETWORK_INSTANCE.sendTo((IMessage)new InfectionPacketHandler.InfectMessage(), (EntityPlayerMP)entity);
                }
            } else if (entity instanceof EntityVillager && ConfigHandler.infectVillagers && (c = rand.nextInt(100)) <= ConfigHandler.villagerInfectChance) {
                entity.func_70690_d(new PotionEffect(HordesInfection.INFECTED, 10000, 0));
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onDeath(LivingDeathEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        World world = entity.field_70170_p;
        if (!world.field_72995_K && (source == HordesInfection.INFECTION_DAMAGE || entity.func_70644_a(HordesInfection.INFECTED))) {
            InfectionDeathEvent newevent = new InfectionDeathEvent(entity, event.getSource());
            MinecraftForge.EVENT_BUS.post((Event)newevent);
            if (newevent.getResult() == Event.Result.DENY) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onInfectDeath(InfectionDeathEvent event) {
        EntityLivingBase entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        if (entity instanceof EntityVillager) {
            EntityZombieVillager zombie = new EntityZombieVillager(world);
            zombie.setForgeProfession(((EntityVillager)entity).getProfessionForge());
            zombie.func_70107_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
                zombie.func_184201_a(slot, entity.func_184582_a(slot));
            }
            zombie.field_70761_aq = entity.field_70761_aq;
            if (entity.func_145818_k_()) {
                zombie.func_96094_a(entity.func_95999_t());
            }
            world.func_72838_d((Entity)zombie);
            entity.func_70106_y();
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onTick(LivingEvent.LivingUpdateEvent event) {
        PotionEffect effect;
        EntityLivingBase entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        if (!world.field_72995_K && entity.func_70644_a(HordesInfection.INFECTED) && (effect = entity.func_70660_b(HordesInfection.INFECTED)).func_76459_b() < 10000 - ConfigHandler.ticksForEffectStage) {
            int a = effect.func_76458_c();
            if (a < 3) {
                entity.func_70690_d(new PotionEffect(HordesInfection.INFECTED, 10000, a + 1));
            } else {
                entity.func_70097_a(HordesInfection.INFECTION_DAMAGE, Float.MAX_VALUE);
            }
        }
    }
}

