/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.infection;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import net.smileycorp.atlas.api.SimpleStringMessage;
import net.smileycorp.hordes.client.ClientHandler;
import net.smileycorp.hordes.infection.CureEntityMessage;
import net.smileycorp.hordes.infection.InfectionRegister;

public class InfectionPacketHandler {
    public static final SimpleNetworkWrapper NETWORK_INSTANCE = NetworkRegistry.INSTANCE.newSimpleChannel("hordes_infection");

    public static void initPackets() {
        NETWORK_INSTANCE.registerMessage(ClientCureMessageHandler.class, SimpleStringMessage.class, 0, Side.CLIENT);
        NETWORK_INSTANCE.registerMessage(InfectMessageHandler.class, InfectMessage.class, 1, Side.CLIENT);
        NETWORK_INSTANCE.registerMessage(CureEntityHandler.class, CureEntityMessage.class, 2, Side.CLIENT);
    }

    public static class InfectMessage
    implements IMessage {
        public void fromBytes(ByteBuf buf) {
        }

        public void toBytes(ByteBuf buf) {
        }
    }

    public static class CureEntityHandler
    implements IMessageHandler<CureEntityMessage, IMessage> {
        public IMessage onMessage(CureEntityMessage message, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                Minecraft mc = Minecraft.func_71410_x();
                mc.func_152344_a(() -> ClientHandler.processCureEntityMessage(message));
            }
            return null;
        }
    }

    public static class InfectMessageHandler
    implements IMessageHandler<InfectMessage, IMessage> {
        public IMessage onMessage(InfectMessage message, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                Minecraft mc = Minecraft.func_71410_x();
                mc.func_152344_a(() -> ClientHandler.onInfect());
            }
            return null;
        }
    }

    public static class ClientCureMessageHandler
    implements IMessageHandler<SimpleStringMessage, IMessage> {
        public IMessage onMessage(SimpleStringMessage message, MessageContext ctx) {
            if (ctx.side == Side.CLIENT) {
                Minecraft mc = Minecraft.func_71410_x();
                mc.func_152344_a(() -> InfectionRegister.readCurePacketData(message.getText()));
            }
            return null;
        }
    }
}

