/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.infection;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.smileycorp.atlas.api.util.RecipeUtils;
import net.smileycorp.hordes.common.ConfigHandler;
import net.smileycorp.hordes.common.Hordes;
import net.smileycorp.hordes.integration.jei.JEIPluginInfection;

public class InfectionRegister {
    private static List<ItemStack> cures = new ArrayList<ItemStack>();
    private static List<ItemStack> curesClient = new ArrayList<ItemStack>();
    private static List<Class<? extends EntityLiving>> infectionEntities = new ArrayList<Class<? extends EntityLiving>>();

    public static void readConfig() {
        InfectionRegister.readInfectionEntities();
        InfectionRegister.readCureItems();
    }

    private static void readInfectionEntities() {
        try {
            if (ConfigHandler.infectionEntities == null) {
                throw new Exception("Infection entity list has loaded as null");
            }
            if (ConfigHandler.infectionEntities.length <= 0) {
                throw new Exception("Infection entity list in config is empty");
            }
            for (String name : ConfigHandler.infectionEntities) {
                String[] nameSplit = name.split(":");
                if (nameSplit.length >= 2) {
                    EntityEntry entry;
                    Class clazz;
                    ResourceLocation loc = new ResourceLocation(nameSplit[0], nameSplit[1]);
                    if (!ForgeRegistries.ENTITIES.containsKey(loc) || !EntityLiving.class.isAssignableFrom(clazz = (entry = (EntityEntry)ForgeRegistries.ENTITIES.getValue(loc)).getEntityClass())) continue;
                    infectionEntities.add(clazz);
                    continue;
                }
                throw new Exception(name + " is not a valid registry.");
            }
        }
        catch (Exception e) {
            Hordes.logError("Failed to read config, " + e.getCause() + " " + e.getMessage(), e);
        }
    }

    private static void readCureItems() {
        try {
            if (ConfigHandler.cureItemList == null) {
                throw new Exception("Cure list has loaded as null");
            }
            if (ConfigHandler.cureItemList.length <= 0) {
                throw new Exception("Cure list in config is empty");
            }
            cures = InfectionRegister.parseCureData(ConfigHandler.cureItemList);
        }
        catch (Exception e) {
            Hordes.logError("Failed to read config, " + e.getCause() + " " + e.getMessage(), e);
        }
    }

    public static void readCurePacketData(String data) {
        try {
            String[] splitData = data.split(";");
            curesClient = InfectionRegister.parseCureData(splitData);
        }
        catch (Exception e) {
            Hordes.logError("Failed to read data from server, " + e.getCause() + " " + e.getMessage(), e);
        }
        if (Loader.isModLoaded((String)"jei")) {
            JEIPluginInfection.setRecipes(curesClient);
        }
    }

    public static String getCurePacketData() {
        StringBuilder builder = new StringBuilder();
        for (ItemStack stack : cures) {
            builder.append(stack.func_77973_b().getRegistryName());
            builder.append(":");
            builder.append(stack.func_77960_j());
            if (stack.func_77978_p() != null) {
                builder.append(stack.func_77978_p().toString());
            }
            builder.append(";");
        }
        return builder.toString();
    }

    public static List<ItemStack> parseCureData(String[] data) throws Exception {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (String name : data) {
            String[] nameSplit;
            NBTTagCompound nbt = null;
            if (name.contains("{")) {
                String nbtstring = name.substring(name.indexOf("{"));
                name = name.substring(0, name.indexOf("{"));
                try {
                    NBTTagCompound parsed = JsonToNBT.func_180713_a((String)nbtstring);
                    if (parsed != null) {
                        nbt = parsed;
                    }
                }
                catch (Exception e) {
                    Hordes.logError("Error parsing nbt for entity " + name + " " + e.getMessage(), e);
                }
            }
            if ((nameSplit = name.split(":")).length >= 2) {
                int meta;
                ResourceLocation loc = new ResourceLocation(nameSplit[0], nameSplit[1]);
                try {
                    meta = nameSplit.length > 2 ? (nameSplit[2].equals("*") ? Short.MAX_VALUE : Integer.valueOf(nameSplit[2])) : 0;
                }
                catch (Exception e) {
                    meta = 0;
                    Hordes.logError("Entry" + name + " has a non integer, non wildcard metadata value", e);
                }
                if (!ForgeRegistries.ITEMS.containsKey(loc)) continue;
                ItemStack stack = new ItemStack((Item)ForgeRegistries.ITEMS.getValue(loc), 1, meta);
                if (nbt != null) {
                    stack.func_77982_d(nbt);
                }
                stacks.add(stack);
                continue;
            }
            throw new Exception(name + " is not a valid registry");
        }
        return stacks;
    }

    static List<ItemStack> getCureList() {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (ItemStack stack : FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT ? curesClient : cures) {
            result.add(new ItemStack(stack.func_77973_b(), stack.func_77960_j()));
        }
        return result;
    }

    public static void addCureItem(ItemStack stack) {
        cures.add(stack);
    }

    public static void removeCureItem(ItemStack stack) {
        for (ItemStack match : cures) {
            if (!RecipeUtils.compareItemStacks((ItemStack)match, (ItemStack)stack, (boolean)true)) continue;
            cures.remove(match);
        }
    }

    public static boolean isCure(ItemStack stack) {
        for (ItemStack cure : FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT ? curesClient : cures) {
            if (!RecipeUtils.compareItemStacks((ItemStack)stack, (ItemStack)cure, (cure.func_77978_p() != null ? 1 : 0) != 0)) continue;
            return true;
        }
        return false;
    }

    public static boolean canCauseInfection(Entity entity) {
        if (entity instanceof EntityLiving) {
            for (Class<? extends EntityLiving> clazz : infectionEntities) {
                if (!clazz.isAssignableFrom(entity.getClass())) continue;
                return true;
            }
        }
        return false;
    }
}

