/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.infection;

import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AbstractAttributeMap;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.smileycorp.hordes.common.ConfigHandler;
import net.smileycorp.hordes.common.ModDefinitions;
import net.smileycorp.hordes.infection.InfectionRegister;

public class PotionInfected
extends Potion {
    public static final ResourceLocation TEXTURE = ModDefinitions.getResource("textures/gui/potions.png");
    private final UUID SPEED_MOD_UUID = UUID.fromString("05d68949-cb8b-4031-92a6-bd75e42b5cdd");
    private final String SPEED_MOD_NAME = ModDefinitions.getName("Infected");
    private final AttributeModifier SPEED_MOD = new AttributeModifier(this.SPEED_MOD_NAME, (double)-0.1f, 2);

    public PotionInfected() {
        super(true, 0x440002);
        String name = "Infected";
        this.func_76390_b("effect." + ModDefinitions.getName(name));
        this.setRegistryName(ModDefinitions.getResource(name));
        this.func_76399_b(0, 0);
    }

    public boolean shouldRender(PotionEffect effect) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_76392_e() {
        Minecraft.func_71410_x().field_71446_o.func_110577_a(TEXTURE);
        return super.func_76392_e();
    }

    public List<ItemStack> getCurativeItems() {
        return ConfigHandler.enableMobInfection ? InfectionRegister.getCureList() : super.getCurativeItems();
    }

    public void func_76394_a(EntityLivingBase entity, int amplifier) {
        if (entity instanceof EntityPlayer) {
            ((EntityPlayer)entity).func_71020_j(0.007f * (float)(amplifier + 1));
        }
    }

    public boolean func_76397_a(int duration, int amplifier) {
        return ConfigHandler.infectHunger;
    }

    public void func_111185_a(EntityLivingBase entity, AbstractAttributeMap map, int amplifier) {
        IAttributeInstance attribute;
        if (amplifier > 0 && ConfigHandler.infectSlowness && (attribute = map.func_111151_a(SharedMonsterAttributes.field_111263_d)) != null) {
            attribute.func_188479_b(this.SPEED_MOD_UUID);
            attribute.func_111121_a(new AttributeModifier(this.SPEED_MOD_UUID, this.SPEED_MOD_NAME + " " + amplifier, this.func_111183_a(amplifier - 1, this.SPEED_MOD), 2));
        }
    }

    public void func_111187_a(EntityLivingBase entity, AbstractAttributeMap map, int amplifier) {
        IAttributeInstance attribute = map.func_111151_a(SharedMonsterAttributes.field_111263_d);
        if (attribute != null) {
            attribute.func_188479_b(this.SPEED_MOD_UUID);
        }
    }
}

