/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.integration.jei;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.JEIPlugin;
import mezz.jei.api.ingredients.IIngredientRegistry;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeWrapper;
import mezz.jei.recipes.RecipeRegistry;
import net.minecraft.item.ItemStack;
import net.smileycorp.hordes.integration.jei.InfectionCureCategory;
import net.smileycorp.hordes.integration.jei.InfectionCureWrapper;

@JEIPlugin
public class JEIPluginInfection
implements IModPlugin {
    public static IJeiHelpers jeiHelpers;
    public static IIngredientRegistry ingredientRegistry;
    private static InfectionCureCategory infectionCategory;
    private static List<InfectionCureWrapper> recipes;
    private static RecipeRegistry recipeRegistry;

    public void registerCategories(IRecipeCategoryRegistration registry) {
        jeiHelpers = registry.getJeiHelpers();
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        infectionCategory = new InfectionCureCategory(guiHelper);
        registry.addRecipeCategories(new IRecipeCategory[]{infectionCategory});
    }

    public void register(@Nonnull IModRegistry registry) {
        ingredientRegistry = registry.getIngredientRegistry();
        registry.handleRecipes(InfectionCureWrapper.class, r -> r, InfectionCureCategory.ID);
    }

    public void onRuntimeAvailable(IJeiRuntime runtime) {
        if (runtime.getRecipeRegistry() instanceof RecipeRegistry) {
            recipeRegistry = (RecipeRegistry)runtime.getRecipeRegistry();
        }
    }

    public static void setRecipes(List<ItemStack> cures) {
        if (recipeRegistry != null) {
            for (InfectionCureWrapper recipe : recipes) {
                recipeRegistry.removeRecipe((IRecipeWrapper)recipe, InfectionCureCategory.ID);
            }
            recipes.clear();
            ArrayList<Object> items = new ArrayList<ItemStack>();
            for (ItemStack stack : cures) {
                items.add(stack);
                if (items.size() != 54) continue;
                recipes.add(new InfectionCureWrapper(items));
                ingredientRegistry.addIngredientsAtRuntime(ItemStack.class, items);
                items = new ArrayList();
            }
            if (!items.isEmpty()) {
                recipes.add(new InfectionCureWrapper(items));
                ingredientRegistry.addIngredientsAtRuntime(ItemStack.class, items);
            }
            for (InfectionCureWrapper recipe : recipes) {
                recipeRegistry.addRecipe((IRecipeWrapper)recipe, InfectionCureCategory.ID);
            }
        }
    }

    static {
        ingredientRegistry = null;
        recipes = new ArrayList<InfectionCureWrapper>();
        recipeRegistry = null;
    }
}

