/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.client;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.smileycorp.hordes.client.ClientConfigHandler;
import net.smileycorp.hordes.client.ClientInfectionEventHandler;
import net.smileycorp.hordes.client.render.ZombiePlayerRenderer;
import net.smileycorp.hordes.common.infection.HordesInfection;
import net.smileycorp.hordes.common.infection.network.CureEntityMessage;

@Mod.EventBusSubscriber(modid="hordes", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientHandler {
    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ClientHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ClientInfectionEventHandler());
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)HordesInfection.ZOMBIE_PLAYER.get()), m -> new ZombiePlayerRenderer(m, ClientConfigHandler.getZombiePlayerColour()));
        RenderingRegistry.registerEntityRenderingHandler((EntityType)((EntityType)HordesInfection.DROWNED_PLAYER.get()), m -> new ZombiePlayerRenderer(m, ClientConfigHandler.getDrownedPlayerColour()));
    }

    public static void playHordeSound(Vector3d dir, ResourceLocation sound) {
        if (((Boolean)ClientConfigHandler.hordeSpawnSound.get()).booleanValue()) {
            Minecraft mc = Minecraft.func_71410_x();
            ClientWorld world = mc.field_71441_e;
            ClientPlayerEntity player = mc.field_71439_g;
            BlockPos pos = new BlockPos(player.func_226277_ct_() + 5.0 * dir.field_72450_a, player.func_226278_cu_(), player.func_226281_cx_() + 5.0 * dir.field_72449_c);
            float pitch = 1 + (world.field_73012_v.nextInt(6) - 3) / 10;
            world.func_184133_a((PlayerEntity)player, pos, new SoundEvent(sound), SoundCategory.HOSTILE, 0.6f, pitch);
        }
    }

    public static void displayMessage(String text) {
        Minecraft mc = Minecraft.func_71410_x();
        IngameGui gui = mc.field_71456_v;
        TranslationTextComponent message = new TranslationTextComponent(text);
        message.func_230530_a_(Style.field_240709_b_.func_240718_a_(ClientConfigHandler.getHordeMessageColour()));
        if ((Integer)ClientConfigHandler.eventNotifyMode.get() == 1) {
            gui.func_146158_b().func_146227_a((ITextComponent)message);
        } else if ((Integer)ClientConfigHandler.eventNotifyMode.get() == 2) {
            gui.field_73838_g = message;
            gui.field_73845_h = (Integer)ClientConfigHandler.eventNotifyDuration.get();
            gui.field_73844_j = false;
        } else if ((Integer)ClientConfigHandler.eventNotifyMode.get() == 3) {
            gui.func_238452_a_(null, null, 5, ((Integer)ClientConfigHandler.eventNotifyDuration.get()).intValue(), 5);
            gui.func_238452_a_((ITextComponent)new StringTextComponent(" "), null, 0, 0, 0);
            gui.func_238452_a_(null, (ITextComponent)message, 0, 0, 0);
        }
    }

    public static void onInfect() {
        if (((Boolean)ClientConfigHandler.playerInfectSound.get()).booleanValue()) {
            Minecraft mc = Minecraft.func_71410_x();
            ClientWorld world = mc.field_71441_e;
            ClientPlayerEntity player = mc.field_71439_g;
            world.func_184133_a((PlayerEntity)player, player.func_233580_cy_(), SoundEvents.field_187941_ho, SoundCategory.HOSTILE, 1.0f, world.field_73012_v.nextFloat());
        }
    }

    public static void processCureEntity(CureEntityMessage message) {
        Minecraft mc = Minecraft.func_71410_x();
        ClientWorld world = mc.field_71441_e;
        MobEntity entity = message.getEntity((World)world);
        world.func_184134_a(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), SoundEvents.field_187604_bf, entity.func_184176_by(), 1.0f, 1.0f, true);
        Random rand = world.field_73012_v;
        for (int i = 0; i < 10; ++i) {
            world.func_195594_a((IParticleData)ParticleTypes.field_197632_y, entity.func_226277_ct_() + (rand.nextDouble() - 0.5) * (double)entity.func_213311_cf() * 1.5, entity.func_226278_cu_() + rand.nextDouble() * (double)entity.func_213302_cg(), entity.func_226281_cx_() + (rand.nextDouble() - 0.5) * (double)entity.func_213311_cf() * 1.5, 0.0, 0.3, 0.0);
        }
    }
}

