/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common;

import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLConstructModEvent;
import net.minecraftforge.fml.event.lifecycle.FMLLoadCompleteEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.smileycorp.hordes.client.ClientConfigHandler;
import net.smileycorp.hordes.common.CommonConfigHandler;
import net.smileycorp.hordes.common.MiscEventHandler;
import net.smileycorp.hordes.common.capability.IZombifyPlayer;
import net.smileycorp.hordes.common.capability.ZombifyPlayer;
import net.smileycorp.hordes.common.hordeevent.HordeEventHandler;
import net.smileycorp.hordes.common.hordeevent.HordeEventRegister;
import net.smileycorp.hordes.common.hordeevent.capability.IHordeEvent;
import net.smileycorp.hordes.common.hordeevent.capability.IHordeSpawn;
import net.smileycorp.hordes.common.hordeevent.network.HordeEventPacketHandler;
import net.smileycorp.hordes.common.infection.HordesInfection;
import net.smileycorp.hordes.common.infection.InfectionEventHandler;
import net.smileycorp.hordes.common.infection.InfectionRegister;
import net.smileycorp.hordes.common.infection.network.InfectionPacketHandler;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="hordes")
@Mod.EventBusSubscriber(modid="hordes", bus=Mod.EventBusSubscriber.Bus.MOD)
public class Hordes {
    private static Logger logger = LogManager.getLogger((String)"The Hordes");
    @CapabilityInject(value=IHordeEvent.class)
    public static final Capability<IHordeEvent> HORDE_EVENT = null;
    @CapabilityInject(value=IHordeSpawn.class)
    public static final Capability<IHordeSpawn> HORDESPAWN = null;
    @CapabilityInject(value=IZombifyPlayer.class)
    public static final Capability<IZombifyPlayer> ZOMBIFY_PLAYER = null;

    public Hordes() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, CommonConfigHandler.config);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, ClientConfigHandler.config);
    }

    @SubscribeEvent
    public static void constructMod(FMLConstructModEvent event) {
        if (((Boolean)CommonConfigHandler.enableHordeEvent.get()).booleanValue()) {
            HordeEventPacketHandler.initPackets();
            MinecraftForge.EVENT_BUS.register((Object)new HordeEventHandler());
        } else {
            MinecraftForge.EVENT_BUS.unregister(HordeEventHandler.class);
        }
        if (((Boolean)CommonConfigHandler.enableMobInfection.get()).booleanValue()) {
            InfectionPacketHandler.initPackets();
            MinecraftForge.EVENT_BUS.register((Object)new InfectionEventHandler());
        } else {
            MinecraftForge.EVENT_BUS.unregister(InfectionEventHandler.class);
        }
        MinecraftForge.EVENT_BUS.register((Object)new MiscEventHandler());
        HordesInfection.EFFECTS.register(FMLJavaModLoadingContext.get().getModEventBus());
        HordesInfection.ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        CapabilityManager.INSTANCE.register(IZombifyPlayer.class, (Capability.IStorage)new IZombifyPlayer.Storage(), ZombifyPlayer::new);
        CapabilityManager.INSTANCE.register(IHordeSpawn.class, (Capability.IStorage)new IHordeSpawn.Storage(), IHordeSpawn.HordeSpawn::new);
        CapabilityManager.INSTANCE.register(IHordeEvent.class, (Capability.IStorage)new IHordeEvent.Storage(), IHordeEvent::createEvent);
    }

    @SubscribeEvent
    public static void loadComplete(FMLLoadCompleteEvent event) {
        if (((Boolean)CommonConfigHandler.enableHordeEvent.get()).booleanValue()) {
            HordeEventRegister.readConfig();
        }
        if (((Boolean)CommonConfigHandler.enableMobInfection.get()).booleanValue()) {
            InfectionRegister.readConfig();
        }
    }

    public static void logInfo(Object message) {
        logger.info(message);
    }

    public static void logError(Object message, Exception e) {
        logger.error(message);
        e.printStackTrace();
    }
}

