/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.hordeevent.capability;

import net.minecraft.nbt.INBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.smileycorp.hordes.common.Hordes;

public interface IHordeSpawn {
    public boolean isHordeSpawned();

    public void setPlayerUUID(String var1);

    public String getPlayerUUID();

    public boolean isSynced();

    public void setSynced();

    public static class Provider
    implements ICapabilitySerializable<INBT> {
        protected IHordeSpawn impl = (IHordeSpawn)Hordes.HORDESPAWN.getDefaultInstance();

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction facing) {
            return cap == Hordes.HORDESPAWN ? LazyOptional.of(() -> this.impl).cast() : LazyOptional.empty();
        }

        public INBT serializeNBT() {
            return Hordes.HORDESPAWN.getStorage().writeNBT(Hordes.HORDESPAWN, (Object)this.impl, null);
        }

        public void deserializeNBT(INBT nbt) {
            Hordes.HORDESPAWN.getStorage().readNBT(Hordes.HORDESPAWN, (Object)this.impl, null, nbt);
        }
    }

    public static class HordeSpawn
    implements IHordeSpawn {
        private String uuid = "";
        private boolean isSynced;

        @Override
        public boolean isHordeSpawned() {
            return !this.uuid.isEmpty();
        }

        @Override
        public void setPlayerUUID(String uuid) {
            this.uuid = uuid;
        }

        @Override
        public String getPlayerUUID() {
            return this.uuid;
        }

        @Override
        public boolean isSynced() {
            return this.isSynced;
        }

        @Override
        public void setSynced() {
            this.isSynced = true;
        }
    }

    public static class Storage
    implements Capability.IStorage<IHordeSpawn> {
        public INBT writeNBT(Capability<IHordeSpawn> capability, IHordeSpawn instance, Direction side) {
            return StringNBT.func_229705_a_((String)instance.getPlayerUUID());
        }

        public void readNBT(Capability<IHordeSpawn> capability, IHordeSpawn instance, Direction side, INBT nbt) {
            instance.setPlayerUUID(((StringNBT)nbt).func_150285_a_());
        }
    }
}

