/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.hordeevent.network;

import java.io.Serializable;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.smileycorp.atlas.api.network.SimpleMessageDecoder;
import net.smileycorp.atlas.api.network.SimpleMessageEncoder;
import net.smileycorp.atlas.api.network.SimpleStringMessage;
import net.smileycorp.hordes.client.ClientHandler;
import net.smileycorp.hordes.common.ModDefinitions;
import net.smileycorp.hordes.common.hordeevent.network.HordeSoundMessage;

public class HordeEventPacketHandler {
    public static SimpleChannel NETWORK_INSTANCE;

    public static void initPackets() {
        NETWORK_INSTANCE = NetworkRegistry.newSimpleChannel((ResourceLocation)ModDefinitions.getResource("HordeEvent"), () -> "1", "1"::equals, "1"::equals);
        NETWORK_INSTANCE.registerMessage(0, HordeSoundMessage.class, (BiConsumer)new SimpleMessageEncoder(), (Function)new SimpleMessageDecoder(HordeSoundMessage.class), (T, K) -> HordeEventPacketHandler.processSoundMessage(T, (NetworkEvent.Context)K.get()));
        NETWORK_INSTANCE.registerMessage(1, SimpleStringMessage.class, (BiConsumer)new SimpleMessageEncoder(), (Function)new SimpleMessageDecoder(SimpleStringMessage.class), (T, K) -> HordeEventPacketHandler.processNotificationMessage(T, (NetworkEvent.Context)K.get()));
    }

    public static void processSoundMessage(HordeSoundMessage message, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> (DistExecutor.SafeRunnable & Serializable)() -> ClientHandler.playHordeSound(message.getDirection(), message.getSound())));
        ctx.setPacketHandled(true);
    }

    public static void processNotificationMessage(SimpleStringMessage message, NetworkEvent.Context ctx) {
        ctx.enqueueWork(() -> DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> (DistExecutor.SafeRunnable & Serializable)() -> ClientHandler.displayMessage(message.getText())));
        ctx.setPacketHandled(true);
    }
}

