/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.infection;

import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.NetworkDirection;
import net.smileycorp.atlas.api.network.SimpleStringMessage;
import net.smileycorp.atlas.api.util.DirectionUtils;
import net.smileycorp.hordes.common.CommonConfigHandler;
import net.smileycorp.hordes.common.event.InfectionDeathEvent;
import net.smileycorp.hordes.common.infection.HordesInfection;
import net.smileycorp.hordes.common.infection.InfectionRegister;
import net.smileycorp.hordes.common.infection.network.InfectMessage;
import net.smileycorp.hordes.common.infection.network.InfectionPacketHandler;

@Mod.EventBusSubscriber(modid="hordes")
public class InfectionEventHandler {
    @SubscribeEvent
    public void onEntityAdded(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity != null && !entity.field_70170_p.field_72995_K && ((Boolean)CommonConfigHandler.infectionEntitiesAggroConversions.get()).booleanValue() && InfectionRegister.canCauseInfection(entity) && entity instanceof MobEntity) {
            ((MobEntity)entity).field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)entity, LivingEntity.class, 10, true, false, InfectionRegister::canBeInfected));
        }
    }

    @SubscribeEvent
    public void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player != null && player instanceof ServerPlayerEntity) {
            InfectionPacketHandler.NETWORK_INSTANCE.sendTo((Object)new SimpleStringMessage(InfectionRegister.getCurePacketData()), ((ServerPlayerEntity)player).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    @SubscribeEvent
    public void onItemStackConsume(LivingEntityUseItemEvent.Finish event) {
        LivingEntity entity = event.getEntityLiving();
        ItemStack stack = event.getItem();
        if (entity.func_70644_a((Effect)HordesInfection.INFECTED.get()) && InfectionRegister.isCure(stack)) {
            entity.func_195063_d((Effect)HordesInfection.INFECTED.get());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onItemUse(PlayerInteractEvent.RightClickItem event) {
        LivingEntity entity;
        ItemStack stack = event.getItemStack();
        RayTraceResult ray = DirectionUtils.getPlayerRayTrace((World)event.getWorld(), (PlayerEntity)event.getPlayer(), (float)5.0f);
        if (ray instanceof EntityRayTraceResult && ((EntityRayTraceResult)ray).func_216348_a() instanceof LivingEntity && (entity = (LivingEntity)((EntityRayTraceResult)ray).func_216348_a()).func_70644_a((Effect)HordesInfection.INFECTED.get()) && InfectionRegister.isCure(stack)) {
            entity.func_195063_d((Effect)HordesInfection.INFECTED.get());
            event.setCanceled(true);
            event.setCancellationResult(ActionResultType.FAIL);
        }
    }

    @SubscribeEvent
    public void onDamage(LivingDamageEvent event) {
        LivingEntity entity = event.getEntityLiving();
        Entity attacker = event.getSource().func_76364_f();
        World world = entity.field_70170_p;
        Random rand = world.field_73012_v;
        if (!world.field_72995_K && InfectionRegister.canCauseInfection(attacker) && !entity.func_70644_a((Effect)HordesInfection.INFECTED.get())) {
            if (entity instanceof PlayerEntity && ((Boolean)CommonConfigHandler.infectPlayers.get()).booleanValue()) {
                int c = rand.nextInt(100);
                if (c <= (Integer)CommonConfigHandler.playerInfectChance.get()) {
                    entity.func_195064_c(new EffectInstance((Effect)HordesInfection.INFECTED.get(), 10000, 0));
                    InfectionPacketHandler.NETWORK_INSTANCE.sendTo((Object)new InfectMessage(), ((ServerPlayerEntity)entity).field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
                }
            } else if (entity instanceof VillagerEntity && ((Boolean)CommonConfigHandler.infectVillagers.get()).booleanValue()) {
                int c = rand.nextInt(100);
                if (c <= (Integer)CommonConfigHandler.villagerInfectChance.get()) {
                    entity.func_195064_c(new EffectInstance((Effect)HordesInfection.INFECTED.get(), 10000, 0));
                }
            } else if (InfectionRegister.canBeInfected((Entity)entity)) {
                InfectionRegister.tryToInfect(entity);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        World world = entity.field_70170_p;
        if (!world.field_72995_K && (source == HordesInfection.INFECTION_DAMAGE || entity.func_70644_a((Effect)HordesInfection.INFECTED.get()))) {
            InfectionDeathEvent newevent = new InfectionDeathEvent(entity, event.getSource());
            MinecraftForge.EVENT_BUS.post((Event)newevent);
            if (newevent.getResult() == Event.Result.DENY) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onInfectDeath(InfectionDeathEvent event) {
        LivingEntity entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        if (entity instanceof VillagerEntity) {
            VillagerEntity villager = (VillagerEntity)entity;
            ZombieVillagerEntity zombie = (ZombieVillagerEntity)EntityType.field_200727_aF.func_200721_a(world);
            zombie.func_213792_a(villager.func_213700_eh());
            zombie.func_213789_a(villager.func_213708_dV());
            zombie.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
            for (EquipmentSlotType slot : EquipmentSlotType.values()) {
                zombie.func_184201_a(slot, entity.func_184582_a(slot));
            }
            if (entity.func_145818_k_()) {
                zombie.func_200203_b(entity.func_200201_e());
            }
            world.func_217376_c((Entity)zombie);
            entity.func_174812_G();
            event.setResult(Event.Result.DENY);
        } else if (InfectionRegister.canBeInfected((Entity)entity)) {
            InfectionRegister.convertEntity(entity);
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onTick(LivingEvent.LivingUpdateEvent event) {
        EffectInstance effect;
        LivingEntity entity = event.getEntityLiving();
        World world = entity.field_70170_p;
        if (!world.field_72995_K && entity.func_70644_a((Effect)HordesInfection.INFECTED.get()) && (effect = entity.func_70660_b((Effect)HordesInfection.INFECTED.get())).func_76459_b() < 10000 - (Integer)CommonConfigHandler.ticksForEffectStage.get()) {
            int a = effect.func_76458_c();
            if (a < 3) {
                entity.func_195064_c(new EffectInstance((Effect)HordesInfection.INFECTED.get(), 10000, a + 1));
            } else {
                entity.func_70097_a(HordesInfection.INFECTION_DAMAGE, Float.MAX_VALUE);
            }
        }
    }
}

