/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.block;

import java.io.IOException;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.HashCache;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.smileycorp.atlas.api.block.ShapedBlock;
import net.smileycorp.atlas.api.block.WoodBlock;

public abstract class AtlasDataProvider
implements DataProvider {
    protected final BlockStateProvider stateProvider;
    protected final LootTableProvider lootProvider;
    protected final RecipeProvider recipeProvider;

    public AtlasDataProvider(DataGenerator gen, String modid, ExistingFileHelper exFileHelper) {
        this.stateProvider = new BlockStateProvider(gen, modid, exFileHelper){

            protected void registerStatesAndModels() {
            }
        };
        this.lootProvider = new LootTableProvider(gen);
        this.recipeProvider = new RecipeProvider(gen){};
    }

    public void m_6865_(HashCache cache) throws IOException {
        this.stateProvider.m_6865_(cache);
        this.registerData();
        this.lootProvider.m_6865_(cache);
        this.recipeProvider.m_6865_(cache);
    }

    protected abstract void registerData();

    public void shapedBlock(ShapedBlock block) {
        this.stateProvider.simpleBlock(block.getBase());
        this.simpleItemBlock(block.getBase());
        this.stateProvider.stairsBlock(block.getStairs(), this.texture(block.getBase()));
        this.simpleItemBlock((Block)block.getStairs());
        this.stateProvider.slabBlock(block.getSlab(), this.texture(block.getBase()), this.texture(block.getBase()));
        this.simpleItemBlock((Block)block.getSlab());
        if (block.getWall() != null) {
            this.stateProvider.wallBlock(block.getWall(), this.texture(block.getBase()));
            this.stateProvider.itemModels().wallInventory(block.getWall().getRegistryName().m_135815_(), this.texture(block.getBase()));
        }
    }

    public void woodBlock(WoodBlock block) {
        this.stateProvider.simpleBlock(block.getPlanks());
        this.simpleItemBlock(block.getPlanks());
        this.stateProvider.stairsBlock(block.getStairs(), this.texture(block.getPlanks()));
        this.simpleItemBlock((Block)block.getStairs());
        this.stateProvider.slabBlock(block.getSlab(), this.texture(block.getPlanks()), this.texture(block.getPlanks()));
        this.simpleItemBlock((Block)block.getSlab());
        this.stateProvider.logBlock(block.getStrippedLog());
        this.simpleItemBlock((Block)block.getStrippedLog());
        this.stateProvider.axisBlock(block.getStrippedWood(), this.texture((Block)block.getStrippedLog()), this.texture((Block)block.getStrippedLog()));
        this.simpleItemBlock((Block)block.getStrippedWood());
        this.stateProvider.logBlock(block.getLog());
        this.simpleItemBlock((Block)block.getLog());
        this.stateProvider.axisBlock(block.getWood(), this.texture((Block)block.getLog()), this.texture((Block)block.getLog()));
        this.simpleItemBlock((Block)block.getWood());
        this.stateProvider.simpleBlock((Block)block.getLeaves());
        this.simpleItemBlock((Block)block.getLeaves());
        if (block.getSapling() != null) {
            this.stateProvider.models().cross(block.getSapling().getRegistryName().m_135815_(), this.texture((Block)block.getSapling()));
            this.simpleItem(block.getSapling().m_5456_());
        }
        this.stateProvider.fenceBlock(block.getFence(), this.texture(block.getPlanks()));
        this.stateProvider.itemModels().fenceInventory(block.getFence().getRegistryName().m_135815_(), this.texture(block.getPlanks()));
        this.stateProvider.fenceGateBlock(block.getFenceGate(), this.texture(block.getPlanks()));
        this.simpleItemBlock((Block)block.getFenceGate());
        this.stateProvider.buttonBlock(block.getButton(), this.texture(block.getPlanks()));
        this.stateProvider.itemModels().buttonInventory(block.getButton().getRegistryName().m_135815_(), this.texture(block.getPlanks()));
        this.stateProvider.pressurePlateBlock(block.getPressurePlate(), this.texture(block.getPlanks()));
        this.simpleItemBlock((Block)block.getPressurePlate());
        this.stateProvider.doorBlock(block.getDoor(), this.texture((Block)block.getDoor(), "_bottom"), this.texture((Block)block.getDoor(), "_top"));
        this.simpleItem(block.getDoor().m_5456_());
        this.stateProvider.trapdoorBlock(block.getTrapdoor(), this.texture((Block)block.getTrapdoor()), true);
        this.simpleItemBlock((Block)block.getTrapdoor());
        this.stateProvider.signBlock((StandingSignBlock)block.getSignBlock(false), (WallSignBlock)block.getSignBlock(true), this.texture(block.getPlanks()));
        this.simpleItem((Item)block.getSignItem());
        this.simpleItem(block.getBoat());
    }

    protected ResourceLocation texture(Block block) {
        return this.texture(block, "");
    }

    protected ResourceLocation texture(Block block, String suffix) {
        ResourceLocation base = block.getRegistryName();
        return new ResourceLocation(base.m_135827_(), "block/" + base.m_135815_() + suffix);
    }

    protected void simpleItemBlock(Block block) {
        this.stateProvider.itemModels().withExistingParent(block.getRegistryName().m_135815_(), this.texture(block));
    }

    protected void simpleItem(Item item) {
        this.stateProvider.itemModels().withExistingParent(item.getRegistryName().m_135815_(), this.stateProvider.mcLoc("item/generated"));
    }
}

