/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.block;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class ShapedBlock {
    protected final String name;
    protected final CreativeModeTab tab;
    protected final Map<BlockShape, RegistryObject<Block>> BLOCKS = Maps.newHashMap();

    public ShapedBlock(String name, CreativeModeTab tab, BlockBehaviour.Properties properties, DeferredRegister<Item> items, DeferredRegister<Block> blocks, boolean hasWall) {
        this.name = name;
        this.tab = tab;
        this.register(items, blocks, () -> new Block(properties), BlockShape.BASE);
        this.register(items, blocks, () -> new StairBlock(() -> this.getBase().m_49966_(), properties), BlockShape.STAIRS);
        this.register(items, blocks, () -> new SlabBlock(properties), BlockShape.SLAB);
        if (hasWall) {
            this.register(items, blocks, () -> new WallBlock(properties), BlockShape.WALL);
        }
    }

    protected void register(DeferredRegister<Item> items, DeferredRegister<Block> blocks, Supplier<Block> supplier, BlockShape shape) {
        Object name = this.name;
        if (shape != BlockShape.BASE) {
            name = (String)name + "_" + shape.name().toLowerCase();
        }
        RegistryObject block = blocks.register((String)name, supplier);
        items.register((String)name, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_(this.tab)));
        this.BLOCKS.put(shape, (RegistryObject<Block>)block);
    }

    public Block get(BlockShape shape) {
        return this.BLOCKS.containsKey((Object)shape) ? (Block)this.BLOCKS.get((Object)shape).get() : null;
    }

    public Block getBase() {
        return this.get(BlockShape.BASE);
    }

    public StairBlock getStairs() {
        return (StairBlock)this.get(BlockShape.STAIRS);
    }

    public SlabBlock getSlab() {
        return (SlabBlock)this.get(BlockShape.SLAB);
    }

    public WallBlock getWall() {
        return (WallBlock)this.get(BlockShape.WALL);
    }

    public static enum BlockShape {
        BASE,
        STAIRS,
        SLAB,
        WALL;

    }
}

