/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.client;

import com.google.common.collect.Maps;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.awt.Color;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.PlayerInfo;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.resources.SkinManager;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class RenderingUtils {
    public static BakedModel replaceRegisteredModel(Map<ResourceLocation, BakedModel> map, ResourceLocation name, Function<BakedModel, BakedModel> function) {
        BakedModel model = function.apply(map.get(name));
        map.put(name, model);
        return model;
    }

    public static void renderCubeQuad(BufferBuilder buffer, double x, double y, double z, int layer, Color colour, TextureAtlasSprite texture, Level world, int luminance, BlockPos pos) {
        for (Direction facing : Direction.values()) {
            RenderingUtils.renderPlanarQuad(buffer, facing, x, y, z, layer, colour, texture, world, luminance, pos);
        }
    }

    public static void renderPlanarQuad(BufferBuilder buffer, Direction facing, double x, double y, double z, int layer, Color colour, TextureAtlasSprite texture, Level world, int luminance, BlockPos pos) {
        Vector4f[] plane = PlanarQuadRenderer.getQuadsFor(facing);
        Vector3f offset = layer == 0 ? new Vector3f(0.0f, 0.0f, 0.0f) : PlanarQuadRenderer.getOffsetFor(facing, x, y, z, layer);
        int rgba = colour.getRGB();
        for (int i = 0; i < 4; ++i) {
            Vector4f quadPos = plane[i];
            float r = (float)((rgba & 0xFF0000) >> 16) / 255.0f;
            float g = (float)((rgba & 0xFF00) >> 8) / 255.0f;
            float b = (float)(rgba & 0xFF) / 255.0f;
            float a = (float)((rgba & 0xFF000000) >> 24) / 255.0f;
            float u = i < 2 ? texture.m_118410_() - 6.25E-6f : texture.m_118409_() + 6.25E-6f;
            float v = i == 1 || i == 2 ? texture.m_118412_() - 6.25E-6f : texture.m_118411_() + 6.25E-6f;
            buffer.m_5483_((double)(quadPos.m_123601_() + offset.m_122239_()), (double)(quadPos.m_123615_() + offset.m_122260_()), (double)(quadPos.m_123616_() + offset.m_122269_())).m_85950_(r, g, b, a).m_7421_(u, v).m_5752_();
        }
    }

    public static ResourceLocation getPlayerTexture(Optional<UUID> uuid, MinecraftProfileTexture.Type type) {
        return PlayerTextureRenderer.getTexture(uuid, type);
    }

    private static class PlanarQuadRenderer {
        private PlanarQuadRenderer() {
        }

        private static Vector3f getOffsetFor(Direction facing, double x, double y, double z, int layer) {
            Vector3f vector = new Vector3f((float)x, (float)y, (float)z);
            switch (facing) {
                case UP: {
                    vector.m_122272_(0.0f, PlanarQuadRenderer.offsetLayer(1.0f, layer), 0.0f);
                    break;
                }
                case DOWN: {
                    vector.m_122272_(0.0f, PlanarQuadRenderer.offsetLayer(0.0f, -layer), 0.0f);
                    break;
                }
                case NORTH: {
                    vector.m_122272_(0.0f, 0.0f, PlanarQuadRenderer.offsetLayer(0.0f, -layer));
                    break;
                }
                case SOUTH: {
                    vector.m_122272_(0.0f, 0.0f, PlanarQuadRenderer.offsetLayer(1.0f, layer));
                    break;
                }
                case EAST: {
                    vector.m_122272_(PlanarQuadRenderer.offsetLayer(1.0f, layer), 0.0f, 0.0f);
                    break;
                }
                case WEST: {
                    vector.m_122272_(PlanarQuadRenderer.offsetLayer(0.0f, -layer), 0.0f, 0.0f);
                }
            }
            return vector;
        }

        private static Vector3f[] get3FQuadsFor(Direction facing) {
            if (facing != null) {
                switch (facing) {
                    case DOWN: {
                        return new Vector3f[]{new Vector3f(0.0f, 0.0f, 16.0f), new Vector3f(16.0f, 0.0f, 0.0f)};
                    }
                    case NORTH: {
                        return new Vector3f[]{new Vector3f(16.0f, 0.0f, 0.0f), new Vector3f(0.0f, 16.0f, 0.0f)};
                    }
                    case SOUTH: {
                        return new Vector3f[]{new Vector3f(16.0f, 0.0f, 16.0f), new Vector3f(0.0f, 16.0f, 16.0f)};
                    }
                    case EAST: {
                        return new Vector3f[]{new Vector3f(16.0f, 0.0f, 16.0f), new Vector3f(16.0f, 16.0f, 0.0f)};
                    }
                    case WEST: {
                        return new Vector3f[]{new Vector3f(0.0f, 0.0f, 16.0f), new Vector3f(0.0f, 16.0f, 0.0f)};
                    }
                }
                return new Vector3f[]{new Vector3f(0.0f, 16.0f, 16.0f), new Vector3f(16.0f, 16.0f, 0.0f)};
            }
            return new Vector3f[]{new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f)};
        }

        private static float offsetLayer(float offset, int layer) {
            float layerOffset = 0.001f * (float)layer;
            return offset + layerOffset;
        }

        private static Vector4f[] getQuadsFor(Direction facing) {
            if (facing != null) {
                switch (facing) {
                    case DOWN: {
                        return new Vector4f[]{new Vector4f(1.0f, 0.0f, 1.0f, 0.0f), new Vector4f(1.0f, 0.0f, 0.0f, 0.0f), new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), new Vector4f(0.0f, 0.0f, 1.0f, 0.0f)};
                    }
                    case NORTH: {
                        return new Vector4f[]{new Vector4f(0.0f, 1.0f, 0.0f, 0.0f), new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), new Vector4f(1.0f, 0.0f, 0.0f, 0.0f), new Vector4f(1.0f, 1.0f, 0.0f, 0.0f)};
                    }
                    case SOUTH: {
                        return new Vector4f[]{new Vector4f(1.0f, 1.0f, 0.0f, 0.0f), new Vector4f(1.0f, 0.0f, 0.0f, 0.0f), new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), new Vector4f(0.0f, 1.0f, 0.0f, 0.0f)};
                    }
                    case EAST: {
                        return new Vector4f[]{new Vector4f(0.0f, 1.0f, 0.0f, 0.0f), new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), new Vector4f(0.0f, 0.0f, 1.0f, 0.0f), new Vector4f(0.0f, 1.0f, 1.0f, 0.0f)};
                    }
                    case WEST: {
                        return new Vector4f[]{new Vector4f(0.0f, 1.0f, 1.0f, 0.0f), new Vector4f(0.0f, 0.0f, 1.0f, 0.0f), new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), new Vector4f(0.0f, 1.0f, 0.0f, 0.0f)};
                    }
                }
                return new Vector4f[]{new Vector4f(1.0f, 0.0f, 0.0f, 0.0f), new Vector4f(1.0f, 0.0f, 1.0f, 0.0f), new Vector4f(0.0f, 0.0f, 1.0f, 0.0f), new Vector4f(0.0f, 0.0f, 0.0f, 0.0f)};
            }
            return new Vector4f[]{new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), new Vector4f(0.0f, 0.0f, 0.0f, 0.0f), new Vector4f(0.0f, 0.0f, 0.0f, 0.0f)};
        }
    }

    private static class PlayerTextureRenderer {
        private static final Map<UUID, GameProfile> PROFILES = Maps.newHashMap();

        private PlayerTextureRenderer() {
        }

        private static ResourceLocation getTexture(Optional<UUID> optional, MinecraftProfileTexture.Type type) {
            GameProfile profile;
            if (optional.isEmpty()) {
                return DefaultPlayerSkin.m_118626_();
            }
            UUID uuid = optional.get();
            PlayerInfo playerinfo = Minecraft.m_91087_().m_91403_().m_104949_(uuid);
            if (playerinfo != null) {
                switch (type) {
                    case SKIN: {
                        return playerinfo.m_105337_();
                    }
                    case CAPE: {
                        return playerinfo.m_105338_();
                    }
                    case ELYTRA: {
                        return playerinfo.m_105339_();
                    }
                }
            }
            Minecraft mc = Minecraft.m_91087_();
            if (PROFILES.containsKey(uuid)) {
                profile = PROFILES.get(uuid);
            } else {
                profile = new GameProfile(uuid, null);
                mc.m_91108_().fillProfileProperties(profile, true);
                PROFILES.put(uuid, profile);
            }
            SkinManager manager = mc.m_91109_();
            Map textures = manager.m_118815_(profile);
            if (textures.containsKey(type)) {
                return manager.m_118825_((MinecraftProfileTexture)textures.get(type), type);
            }
            switch (type) {
                case SKIN: {
                    return DefaultPlayerSkin.m_118627_((UUID)Player.m_36198_((GameProfile)profile));
                }
                case ELYTRA: {
                    return new ResourceLocation("textures/entity/elytra.png");
                }
            }
            return null;
        }
    }
}

