/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.client.entity;

import com.mojang.datafixers.util.Pair;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.smileycorp.atlas.api.BoatRegistry;
import net.smileycorp.atlas.api.entity.AtlasBoat;

public class AtlasBoatRenderer
extends BoatRenderer {
    private static boolean registered = false;
    private final EntityRendererProvider.Context ctx;

    public AtlasBoatRenderer(EntityRendererProvider.Context ctx) {
        super(ctx);
        this.ctx = ctx;
    }

    public Pair<ResourceLocation, BoatModel> getModelWithLocation(Boat boat) {
        BoatRegistry.Type type = ((AtlasBoat)boat).getAtlasType();
        ResourceLocation registry = type == null ? new ResourceLocation("oak") : type.getRegistryName();
        ResourceLocation loc = new ResourceLocation(registry.m_135827_(), "textures/entity/boat/" + registry.m_135815_() + ".png");
        return Pair.of((Object)loc, (Object)new BoatModel(this.ctx.m_174023_(new ModelLayerLocation(new ResourceLocation("boat/oak"), "main"))));
    }

    public static void register() {
        System.out.println("[Atlaslib] registering boat renderer");
        EntityRenderers.m_174036_((EntityType)((EntityType)BoatRegistry.BOAT_ENTITY.get()), AtlasBoatRenderer::new);
        registered = true;
    }

    public static boolean isRegistered() {
        return registered;
    }
}

