/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.item;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ArmourSet {
    final String modid;
    final String name;
    final Tiers material;
    protected final Map<ArmourType, Item> tools = new HashMap<ArmourType, Item>();

    public ArmourSet(String modid, String name, Tiers material, CreativeModeTab tab) {
        this(modid, name, material, tab, ArmorItem.class);
    }

    public ArmourSet(String modid, String name, Tiers material, CreativeModeTab tab, Class<? extends ArmorItem> clazz) {
        this.name = name;
        this.modid = modid;
        this.material = material;
        for (ArmourType type : ArmourType.values()) {
            ArmorItem item = type.createItem(modid, name, (Tier)material, tab, null);
            if (item == null) continue;
            this.tools.put(type, (Item)item);
        }
    }

    public String getModID() {
        return this.modid;
    }

    public String getName() {
        return this.name;
    }

    public Tier getMaterial() {
        return this.material;
    }

    public Item getItem(ArmourType type) {
        return this.tools.get(type);
    }

    public Collection<Item> getItems() {
        return this.tools.values();
    }

    public void registerItems(IForgeRegistry<Item> registry) {
        for (Item tool : this.tools.values()) {
            registry.register((IForgeRegistryEntry)tool);
        }
    }

    public static class ArmourType {
        static Set<ArmourType> REGISTERED_TYPES = new HashSet<ArmourType>();
        public static ArmourType HELMET = ArmourType.register("helmet", EquipmentSlot.HEAD);
        public static ArmourType CHESTPLATE = ArmourType.register("chestplate", EquipmentSlot.CHEST);
        public static ArmourType LEGGINGS = ArmourType.register("leggings", EquipmentSlot.LEGS);
        public static ArmourType BOOTS = ArmourType.register("boots", EquipmentSlot.FEET);
        protected final String name;
        protected final EquipmentSlot slot;

        ArmourType(String name, EquipmentSlot slot) {
            this.name = name;
            this.slot = slot;
        }

        public static Set<ArmourType> values() {
            return REGISTERED_TYPES;
        }

        public static ArmourType register(String name, EquipmentSlot slot) {
            ArmourType type = new ArmourType(name, slot);
            REGISTERED_TYPES.add(type);
            return type;
        }

        public String getName() {
            return this.name;
        }

        public ArmorItem createItem(String modid, String name, Tier material, CreativeModeTab tab, Class<? extends ArmorItem> clazz) {
            try {
                ArmorItem item = (ArmorItem)ObfuscationReflectionHelper.findConstructor(clazz, (Class[])new Class[]{Tier.class, EquipmentSlot.class, Item.Properties.class}).newInstance(material, this.slot, new Item.Properties().m_41491_(tab));
                item.setRegistryName(new ResourceLocation(modid, name + "_" + this.name));
                return item;
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                e.printStackTrace();
                return null;
            }
        }
    }
}

