/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.item;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.RegistryObject;

public class ToolSet {
    final String name;
    final Tier material;
    Map<ToolType, RegistryObject<Item>> tools = new HashMap<ToolType, RegistryObject<Item>>();

    public ToolSet(String name, Tier material, CreativeModeTab tab, DeferredRegister<Item> registry) {
        this(name, material, tab, tab, registry);
    }

    public ToolSet(String name, Tier material, CreativeModeTab toolTab, CreativeModeTab weaponTab, DeferredRegister<Item> registry) {
        this.name = name;
        this.material = material;
        Iterator<ToolType> iterator = ToolType.values().iterator();
        while (iterator.hasNext()) {
            ToolType type;
            RegistryObject<Item> item = type.createItem(name, material, (type = iterator.next()).isWeapon() ? weaponTab : toolTab, registry);
            if (item == null) continue;
            this.tools.put(type, item);
        }
    }

    public String getName() {
        return this.name;
    }

    public Tier getMaterial() {
        return this.material;
    }

    public Item getItem(ToolType type) {
        return (Item)this.tools.get(type).get();
    }

    public Collection<Item> getItems() {
        return this.tools.values().stream().map(item -> (Item)item.get()).toList();
    }

    public static class ToolType {
        static Set<ToolType> REGISTERED_TYPES = new HashSet<ToolType>();
        public static ToolType SWORD = ToolType.register("sword", (material, properties) -> new SwordItem(material, 0, 0.0f, properties), true);
        public static ToolType HOE = ToolType.register("hoe", (material, properties) -> new HoeItem(material, 0, 0.0f, properties));
        public static ToolType PICKAXE = ToolType.register("pickaxe", (material, properties) -> new PickaxeItem(material, 0, 0.0f, properties));
        public static ToolType AXE = ToolType.register("axe", (material, properties) -> new AxeItem(material, 0.0f, 0.0f, properties));
        public static ToolType SHOVEL = ToolType.register("shovel", (material, properties) -> new ShovelItem(material, 0.0f, 0.0f, properties));
        protected final String name;
        protected final BiFunction<Tier, Item.Properties, TieredItem> function;
        protected final boolean isWeapon;

        ToolType(String name, BiFunction<Tier, Item.Properties, TieredItem> function, boolean isWeapon) {
            this.name = name;
            this.function = function;
            this.isWeapon = isWeapon;
        }

        public static Set<ToolType> values() {
            return REGISTERED_TYPES;
        }

        public static ToolType register(String name, BiFunction<Tier, Item.Properties, TieredItem> function) {
            return ToolType.register(name, function, false);
        }

        public static ToolType register(String name, BiFunction<Tier, Item.Properties, TieredItem> function, boolean isWeapon) {
            ToolType type = new ToolType(name, function, isWeapon);
            REGISTERED_TYPES.add(type);
            return type;
        }

        public boolean isWeapon() {
            return this.isWeapon;
        }

        public String getName() {
            return this.name;
        }

        public RegistryObject<Item> createItem(String name, Tier material, CreativeModeTab tab, DeferredRegister<Item> registry) {
            return registry.register(name + "_" + this.name, () -> (Item)this.function.apply(material, new Item.Properties().m_41491_(tab)));
        }
    }
}

