/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.client;

import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.smileycorp.hordes.client.ClientConfigHandler;
import net.smileycorp.hordes.client.ClientInfectionEventHandler;
import net.smileycorp.hordes.client.render.ZombiePlayerRenderer;
import net.smileycorp.hordes.common.infection.HordesInfection;
import net.smileycorp.hordes.common.infection.network.CureEntityMessage;

@Mod.EventBusSubscriber(modid="hordes", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ClientHandler {
    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new ClientHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ClientInfectionEventHandler());
    }

    @SubscribeEvent
    public static void registerEntityRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerEntityRenderer((EntityType)HordesInfection.ZOMBIE_PLAYER.get(), ctx -> new ZombiePlayerRenderer(ctx, ClientConfigHandler.getZombiePlayerColour()));
        event.registerEntityRenderer((EntityType)HordesInfection.DROWNED_PLAYER.get(), ctx -> new ZombiePlayerRenderer(ctx, ClientConfigHandler.getDrownedPlayerColour()));
    }

    @SubscribeEvent
    public static void registerLayers(EntityRenderersEvent.RegisterLayerDefinitions event) {
        event.registerLayerDefinition(ZombiePlayerRenderer.MAIN_LAYER, ZombiePlayerRenderer::createMainLayer);
    }

    public static void playHordeSound(Vec3 vec3, ResourceLocation sound) {
        if (((Boolean)ClientConfigHandler.hordeSpawnSound.get()).booleanValue()) {
            Minecraft mc = Minecraft.m_91087_();
            ClientLevel level = mc.f_91073_;
            LocalPlayer player = mc.f_91074_;
            BlockPos pos = new BlockPos(player.m_20185_() + 5.0 * vec3.f_82479_, player.m_20186_(), player.m_20189_() + 5.0 * vec3.f_82481_);
            float pitch = 1 + (level.f_46441_.nextInt(6) - 3) / 10;
            level.m_5594_((Player)player, pos, new SoundEvent(sound), SoundSource.HOSTILE, 0.6f, pitch);
        }
    }

    public static void displayMessage(String text) {
        Minecraft mc = Minecraft.m_91087_();
        Gui gui = mc.f_91065_;
        TranslatableComponent message = new TranslatableComponent(text);
        message.m_6270_(Style.f_131099_.m_131148_(ClientConfigHandler.getHordeMessageColour()));
        if ((Integer)ClientConfigHandler.eventNotifyMode.get() == 1) {
            gui.m_93076_().m_93785_((Component)message);
        } else if ((Integer)ClientConfigHandler.eventNotifyMode.get() == 2) {
            gui.f_92990_ = message;
            gui.f_92991_ = (Integer)ClientConfigHandler.eventNotifyDuration.get();
            gui.f_92992_ = false;
        } else if ((Integer)ClientConfigHandler.eventNotifyMode.get() == 3) {
            gui.m_168684_(5, ((Integer)ClientConfigHandler.eventNotifyDuration.get()).intValue(), 5);
            gui.m_168711_((Component)message);
        }
    }

    public static void onInfect() {
        if (((Boolean)ClientConfigHandler.playerInfectSound.get()).booleanValue()) {
            Minecraft mc = Minecraft.m_91087_();
            ClientLevel level = mc.f_91073_;
            LocalPlayer player = mc.f_91074_;
            level.m_5594_((Player)player, player.m_142538_(), SoundEvents.f_12616_, SoundSource.HOSTILE, 1.0f, level.f_46441_.nextFloat());
        }
    }

    public static void processCureEntity(CureEntityMessage message) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        Mob entity = message.getEntity((Level)level);
        level.m_7785_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11871_, entity.m_5720_(), 1.0f, 1.0f, true);
        Random rand = level.f_46441_;
        for (int i = 0; i < 10; ++i) {
            level.m_7106_((ParticleOptions)ParticleTypes.f_123748_, entity.m_20185_() + (rand.nextDouble() - 0.5) * (double)entity.m_20205_() * 1.5, entity.m_20186_() + rand.nextDouble() * (double)entity.m_20206_(), entity.m_20189_() + (rand.nextDouble() - 0.5) * (double)entity.m_20205_() * 1.5, 0.0, 0.3, 0.0);
        }
    }
}

