/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common;

import java.util.Collection;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.entity.living.LivingConversionEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.smileycorp.hordes.common.CommonConfigHandler;
import net.smileycorp.hordes.common.Hordes;
import net.smileycorp.hordes.common.ModDefinitions;
import net.smileycorp.hordes.common.capability.IZombifyPlayer;
import net.smileycorp.hordes.common.entities.IZombiePlayer;
import net.smileycorp.hordes.common.infection.HordesInfection;

@Mod.EventBusSubscriber(modid="hordes", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MiscEventHandler {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity != null) {
            LazyOptional optional;
            Level level = entity.f_19853_;
            if (!level.f_46443_ && entity instanceof Player & !(entity instanceof FakePlayer) && (entity.m_21023_((MobEffect)HordesInfection.INFECTED.get()) && ((Boolean)CommonConfigHandler.enableMobInfection.get()).booleanValue() || ((Boolean)CommonConfigHandler.zombieGraves.get()).booleanValue() || entity.m_5842_() && ((Boolean)CommonConfigHandler.drownedGraves.get()).booleanValue()) && (optional = entity.getCapability(Hordes.ZOMBIFY_PLAYER, null)).isPresent()) {
                ((IZombifyPlayer)optional.resolve().get()).createZombie((Player)entity);
            }
        }
    }

    @SubscribeEvent(receiveCanceled=true)
    public void onDrop(LivingDropsEvent event) {
        if (event.getEntity() instanceof Player) {
            IZombifyPlayer cap;
            Mob zombie;
            LazyOptional optional;
            Player player = (Player)event.getEntity();
            Level level = player.f_19853_;
            if (!level.f_46443_ & !(player instanceof FakePlayer) && (player.m_21023_((MobEffect)HordesInfection.INFECTED.get()) && ((Boolean)CommonConfigHandler.enableMobInfection.get()).booleanValue() || ((Boolean)CommonConfigHandler.zombieGraves.get()).booleanValue()) && (optional = player.getCapability(Hordes.ZOMBIFY_PLAYER, null)).isPresent() && (zombie = (cap = (IZombifyPlayer)optional.resolve().get()).getZombie()) != null) {
                Collection drops = event.getDrops();
                ((IZombiePlayer)zombie).setInventory(drops);
                zombie.m_21530_();
                level.m_7967_((Entity)zombie);
                drops.clear();
                cap.clearZombie();
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void attachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        Entity entity = (Entity)event.getObject();
        if (entity instanceof Player & !(entity instanceof FakePlayer)) {
            event.addCapability(ModDefinitions.getResource("Zombify"), (ICapabilityProvider)new IZombifyPlayer.Provider());
        }
    }

    @SubscribeEvent
    public void entityConvert(LivingConversionEvent.Post event) {
        LivingEntity before = event.getEntityLiving();
        if (before.f_19853_.f_46443_) {
            return;
        }
        LivingEntity after = event.getOutcome();
        if (before instanceof AbstractHorse && after instanceof AbstractHorse) {
            SimpleContainer beforeInv = ((AbstractHorse)before).f_30520_;
            SimpleContainer afterInv = ((AbstractHorse)after).f_30520_;
            for (int i = 0; i < Math.min(beforeInv.m_6643_(), afterInv.m_6643_()); ++i) {
                afterInv.m_6836_(i, beforeInv.m_8020_(i).m_41777_());
            }
        }
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)HordesInfection.ZOMBIE_PLAYER.get(), Zombie.m_34328_().m_22265_());
        event.put((EntityType)HordesInfection.DROWNED_PLAYER.get(), Drowned.m_34328_().m_22265_());
    }
}

