/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.hordeevent.capability;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.smileycorp.atlas.api.entity.ai.GoToEntityPositionGoal;
import net.smileycorp.atlas.api.network.SimpleStringMessage;
import net.smileycorp.atlas.api.recipe.WeightedOutputs;
import net.smileycorp.atlas.api.util.DirectionUtils;
import net.smileycorp.hordes.common.CommonConfigHandler;
import net.smileycorp.hordes.common.Hordes;
import net.smileycorp.hordes.common.event.HordeBuildSpawntableEvent;
import net.smileycorp.hordes.common.event.HordeEndEvent;
import net.smileycorp.hordes.common.event.HordeSpawnEntityEvent;
import net.smileycorp.hordes.common.event.HordeStartEvent;
import net.smileycorp.hordes.common.event.HordeStartWaveEvent;
import net.smileycorp.hordes.common.hordeevent.HordeEventRegister;
import net.smileycorp.hordes.common.hordeevent.HordeSpawnEntry;
import net.smileycorp.hordes.common.hordeevent.capability.HordeSavedData;
import net.smileycorp.hordes.common.hordeevent.capability.IHordeEvent;
import net.smileycorp.hordes.common.hordeevent.capability.IHordeSpawn;
import net.smileycorp.hordes.common.hordeevent.network.HordeEventPacketHandler;
import net.smileycorp.hordes.common.hordeevent.network.HordeSoundMessage;

class HordeEvent
implements IHordeEvent {
    private Set<Mob> entitiesSpawned = new HashSet<Mob>();
    private int timer = 0;
    private int day = 0;
    private int nextDay = -1;
    private boolean hasChanged = false;
    private Random rand = new Random();

    public HordeEvent() {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            HordeSavedData data = HordeSavedData.getData(ServerLifecycleHooks.getCurrentServer().m_129783_());
            this.nextDay = data.getNextDay();
        }
    }

    public void readFromNBT(CompoundTag nbt) {
        this.entitiesSpawned.clear();
        if (nbt.m_128441_("timer")) {
            this.timer = nbt.m_128451_("timer");
        }
        if (nbt.m_128441_("nextDay")) {
            this.nextDay = nbt.m_128451_("nextDay");
        }
        if (nbt.m_128441_("day")) {
            this.day = nbt.m_128451_("day");
        }
    }

    public CompoundTag writeToNBT(CompoundTag nbt) {
        nbt.m_128405_("timer", this.timer);
        nbt.m_128405_("nextDay", this.nextDay);
        nbt.m_128405_("day", this.day);
        this.hasChanged = false;
        return nbt;
    }

    public void update(Player player) {
        Level level = player.f_19853_;
        if (!level.f_46443_ && player != null && level.m_46472_() == Level.f_46428_) {
            if (this.timer % (Integer)CommonConfigHandler.hordeSpawnInterval.get() == 0) {
                int amount = (int)((double)((Integer)CommonConfigHandler.hordeSpawnAmount.get()).intValue() * (1.0 + (double)(this.day / (Integer)CommonConfigHandler.hordeSpawnDays.get()) * ((Double)CommonConfigHandler.hordeSpawnMultiplier.get() - 1.0)));
                List players = level.m_6907_();
                for (Player entity : players) {
                    if (entity == player || !(player.m_20270_((Entity)entity) <= 25.0f)) continue;
                    amount = (int)Math.floor((double)amount * (Double)CommonConfigHandler.hordeMultiplayerScaling.get());
                }
                this.spawnWave(player, amount);
            }
            --this.timer;
            if (this.timer == 0) {
                this.stopEvent(player, false);
            }
            this.hasChanged = true;
        }
    }

    @Override
    public void spawnWave(Player player, int count) {
        this.cleanSpawns();
        Level level = player.f_19853_;
        HordeStartWaveEvent startEvent = new HordeStartWaveEvent(player, this, count);
        MinecraftForge.EVENT_BUS.post((Event)startEvent);
        if (startEvent.isCanceled()) {
            return;
        }
        count = startEvent.getCount();
        Vec3 basedir = DirectionUtils.getRandomDirectionVecXZ((Random)this.rand);
        BlockPos basepos = DirectionUtils.getClosestLoadedPos((Level)level, (BlockPos)player.m_142538_(), (Vec3)basedir, (double)75.0, (int)7, (int)0);
        int i = 0;
        while (basepos.equals((Object)player.m_142538_())) {
            basedir = DirectionUtils.getRandomDirectionVecXZ((Random)this.rand);
            basepos = DirectionUtils.getClosestLoadedPos((Level)level, (BlockPos)player.m_142538_(), (Vec3)basedir, (double)75.0, (int)7, (int)0);
            if (++i != 20) continue;
            this.logInfo("Unable to find unlit pos for horde " + this + " ignoring light level");
            basepos = DirectionUtils.getClosestLoadedPos((Level)level, (BlockPos)player.m_142538_(), (Vec3)basedir, (double)75.0);
            break;
        }
        HordeBuildSpawntableEvent buildTableEvent = new HordeBuildSpawntableEvent(player, HordeEventRegister.getSpawnTable(this.day), this);
        MinecraftForge.EVENT_BUS.post((Event)buildTableEvent);
        WeightedOutputs<HordeSpawnEntry> spawntable = buildTableEvent.spawntable;
        if (spawntable.isEmpty()) {
            this.logInfo("Spawntable is empty, stopping wave spawn.");
            return;
        }
        if (count > 0) {
            if (player instanceof ServerPlayer) {
                HordeEventPacketHandler.NETWORK_INSTANCE.sendTo((Object)new HordeSoundMessage(basedir, startEvent.getSound()), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
            }
        } else {
            this.logInfo("Stopping wave spawn because count is " + count);
        }
        for (int n = 0; n < count; ++n) {
            if (this.entitiesSpawned.size() > (Integer)CommonConfigHandler.hordeSpawnMax.get()) {
                this.logInfo("Can't spawn wave because max cap has been reached");
                return;
            }
            Vec3 dir = DirectionUtils.getRandomDirectionVecXZ((Random)this.rand);
            BlockPos pos = DirectionUtils.getClosestLoadedPos((Level)level, (BlockPos)basepos, (Vec3)dir, (double)this.rand.nextInt(10));
            HordeSpawnEntry entry = (HordeSpawnEntry)spawntable.getResult(this.rand);
            EntityType<?> type = entry.getEntity();
            try {
                Mob entity = (Mob)type.m_20615_(level);
                entity.m_7378_(HordeEventRegister.getEntryFor(entity, this.day).getNBT());
                HordeSpawnEntityEvent spawnEntityEvent = new HordeSpawnEntityEvent(player, entity, pos, this);
                MinecraftForge.EVENT_BUS.post((Event)spawnEntityEvent);
                if (!spawnEntityEvent.isCanceled()) {
                    entity = spawnEntityEvent.entity;
                    entity.m_7378_(entry.getNBT());
                    pos = spawnEntityEvent.pos;
                    entity.m_6518_((ServerLevelAccessor)level, level.m_6436_(pos), null, null, null);
                    entity.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
                    entity.m_21051_(Attributes.f_22277_).m_22100_(100.0);
                    if (!level.m_7967_((Entity)entity)) {
                        Hordes.logError("Unable to spawn entity from " + type, new Exception());
                    }
                    ((IHordeSpawn)entity.getCapability(Hordes.HORDESPAWN, null).resolve().get()).setPlayerUUID(player.m_142081_().toString());
                    this.registerEntity(entity);
                    this.hasChanged = true;
                    entity.f_21346_.m_25386_().forEach(goal -> goal.m_8041_());
                    if (entity instanceof PathfinderMob) {
                        entity.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)entity, new Class[0]));
                    }
                    entity.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal(entity, Player.class, true));
                    entity.f_21345_.m_25352_(6, (Goal)new GoToEntityPositionGoal(entity, (Entity)player));
                    continue;
                }
                this.logInfo("Entity spawn event has been cancelled, not spawning entity  of class " + type);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                Hordes.logError("Unable to spawn entity from " + type, e);
            }
        }
    }

    private void cleanSpawns() {
        ArrayList<Mob> toRemove = new ArrayList<Mob>();
        for (Mob entity : this.entitiesSpawned) {
            LazyOptional optional;
            if (!(entity.m_21224_() | !entity.m_6084_()) || !(optional = entity.getCapability(Hordes.HORDESPAWN, null)).isPresent()) continue;
            IHordeSpawn cap = (IHordeSpawn)optional.resolve().get();
            cap.setPlayerUUID("");
            toRemove.add(entity);
        }
        this.entitiesSpawned.removeAll(toRemove);
    }

    @Override
    public boolean isHordeDay(Player player) {
        Level level = player.f_19853_;
        if (level.f_46443_ | level.m_46472_() != Level.f_46428_) {
            return false;
        }
        return this.isActive(player) || Math.floor(level.m_46468_() / (long)((Integer)CommonConfigHandler.dayLength.get()).intValue()) >= (double)this.nextDay;
    }

    public boolean isActive(Player player) {
        return this.timer > 0;
    }

    @Override
    public boolean hasChanged() {
        return this.hasChanged;
    }

    @Override
    public void setPlayer(Player player) {
        HashSet<Mob> toRemove = new HashSet<Mob>();
        for (Mob entity : this.entitiesSpawned) {
            if (entity != null) {
                GoToEntityPositionGoal task = null;
                for (WrappedGoal entry : (WrappedGoal[])entity.f_21345_.m_25386_().toArray(WrappedGoal[]::new)) {
                    if (!(entry.m_26015_() instanceof GoToEntityPositionGoal)) continue;
                    task = (GoToEntityPositionGoal)entry.m_26015_();
                    break;
                }
                if (task == null) continue;
                entity.f_21345_.m_25363_(task);
                entity.f_21345_.m_25352_(6, (Goal)new GoToEntityPositionGoal(entity, (Entity)player));
                continue;
            }
            toRemove.add(entity);
        }
        this.entitiesSpawned.removeAll(toRemove);
        this.hasChanged = true;
    }

    @Override
    public void tryStartEvent(Player player, int duration, boolean isCommand) {
        if (player != null) {
            Level level = player.f_19853_;
            if (level.m_46472_() == Level.f_46428_) {
                HordeStartEvent startEvent = new HordeStartEvent(player, this, isCommand);
                MinecraftForge.EVENT_BUS.post((Event)startEvent);
                if (startEvent.isCanceled()) {
                    return;
                }
                HordeBuildSpawntableEvent buildTableEvent = new HordeBuildSpawntableEvent(player, HordeEventRegister.getSpawnTable((int)Math.floor(level.m_46468_() / (long)((Integer)CommonConfigHandler.dayLength.get()).intValue())), this);
                MinecraftForge.EVENT_BUS.post((Event)buildTableEvent);
                if (!buildTableEvent.spawntable.isEmpty()) {
                    this.timer = duration;
                    this.hasChanged = true;
                    this.sendMessage(player, startEvent.getMessage());
                    this.day = isCommand ? (int)Math.floor(level.m_46468_() / (long)((Integer)CommonConfigHandler.dayLength.get()).intValue()) : this.nextDay;
                } else {
                    this.logInfo("Spawntable is empty, canceling event start.");
                }
                if (!isCommand) {
                    this.nextDay = HordeSavedData.getData((ServerLevel)level).getNextDay();
                }
            }
        } else {
            Hordes.logError("player is null for " + this.toString(), new NullPointerException());
        }
    }

    @Override
    public void setNextDay(int day) {
        this.nextDay = day;
    }

    @Override
    public int getNextDay() {
        return this.nextDay;
    }

    private void sendMessage(Player player, String str) {
        HordeEventPacketHandler.NETWORK_INSTANCE.sendTo((Object)new SimpleStringMessage(str), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    @Override
    public void stopEvent(Player player, boolean isCommand) {
        HordeEndEvent endEvent = new HordeEndEvent(player, this, isCommand);
        MinecraftForge.EVENT_BUS.post((Event)endEvent);
        this.timer = 0;
        this.cleanSpawns();
        this.sendMessage(player, endEvent.getMessage());
        this.hasChanged = true;
    }

    @Override
    public void removeEntity(Mob entity) {
        this.entitiesSpawned.remove(entity);
    }

    @Override
    public void registerEntity(Mob entity) {
        if (!this.entitiesSpawned.contains(entity)) {
            this.entitiesSpawned.add(entity);
        }
    }

    public String toString(Player player) {
        return "OngoingHordeEvent@" + Integer.toHexString(this.hashCode()) + "[player=" + (player == null ? "null" : player.m_7755_().getString()) + ", isActive=" + (this.timer > 0) + ", ticksLeft=" + this.timer + ", entityCount=" + this.entitiesSpawned.size() + ", nextDay=" + this.nextDay + ", day=" + this.day + "]";
    }

    private void logInfo(Object message) {
        Hordes.logInfo("[" + this + "]" + message);
    }

    public List<String> getEntityStrings() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("\tentities: {" + (this.entitiesSpawned.isEmpty() ? "}" : ""));
        ArrayList<Mob> entitylist = new ArrayList<Mob>(this.entitiesSpawned);
        for (int i = 0; i < entitylist.size(); i += 10) {
            List sublist = entitylist.subList(i, Math.min(i + 9, entitylist.size() - 1));
            StringBuilder builder = new StringBuilder();
            builder.append("\t\t");
            for (Mob entity : sublist) {
                builder.append(entity.getClass().getSimpleName() + "@");
                builder.append(Integer.toHexString(entity.hashCode()));
                if (entitylist.indexOf(entity) >= entitylist.size() - 1) continue;
                builder.append(", ");
            }
            builder.append("}");
            result.add(builder.toString());
        }
        return result;
    }

    @Override
    public void reset(ServerLevel level) {
        this.entitiesSpawned.clear();
        HordeSavedData data = HordeSavedData.getData(level);
        this.nextDay = data.getNextDay();
    }
}

