/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.hordeevent.capability;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.smileycorp.hordes.common.CommonConfigHandler;
import net.smileycorp.hordes.common.Hordes;
import net.smileycorp.hordes.common.hordeevent.capability.HordeEvent;

public class HordeSavedData
extends SavedData {
    public static final String DATA = "hordes_HordeEvent";
    private int nextDay = 0;
    protected Level level = null;

    public void load(CompoundTag nbt) {
        int next;
        if (nbt.m_128441_("nextDay") && (next = nbt.m_128451_("nextDay")) > this.nextDay) {
            this.nextDay = next;
        }
    }

    public CompoundTag m_7176_(CompoundTag nbt) {
        nbt.m_128405_("nextDay", this.nextDay);
        return nbt;
    }

    public int getNextDay() {
        return this.nextDay;
    }

    public void setNextDay(int nextDay) {
        this.nextDay = nextDay;
    }

    public Map<Player, HordeEvent> getEvents() {
        HashMap<Player, HordeEvent> events = new HashMap<Player, HordeEvent>();
        if (!this.level.f_46443_) {
            for (Player player : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
                LazyOptional optional = player.getCapability(Hordes.HORDE_EVENT, null);
                if (!(optional.isPresent() & !player.m_21224_())) continue;
                events.put(player, (HordeEvent)player.getCapability(Hordes.HORDE_EVENT, null).resolve().get());
            }
        }
        return events;
    }

    public void save() {
        this.m_77762_();
        if (this.level instanceof ServerLevel) {
            ((ServerLevel)this.level).m_7726_().m_8483_().m_164855_(DATA, (SavedData)this);
        }
    }

    public List<String> getDebugText() {
        ArrayList<String> out = new ArrayList<String>();
        out.add(this.toString());
        out.add("Existing events: {");
        for (Map.Entry<Player, HordeEvent> entry : this.getEvents().entrySet()) {
            out.add("\t" + entry.getValue().toString(entry.getKey()));
            out.addAll(entry.getValue().getEntityStrings());
        }
        out.add("}");
        return out;
    }

    public String toString() {
        return super.toString() + "[levelTime: " + this.level.m_46468_() + ", nextDay=" + this.nextDay + "]";
    }

    public static HordeSavedData getData(ServerLevel level) {
        HordeSavedData data = (HordeSavedData)level.m_7726_().m_8483_().m_164861_(nbt -> HordeSavedData.getDataFromNBT(level, nbt), () -> HordeSavedData.getCleanData(level), DATA);
        if (data == null) {
            data = HordeSavedData.getCleanData(level);
        }
        level.m_7726_().m_8483_().m_164855_(DATA, (SavedData)data);
        return data;
    }

    private static HordeSavedData getDataFromNBT(ServerLevel level, CompoundTag nbt) {
        HordeSavedData data = HordeSavedData.getCleanData(level);
        data.load(nbt);
        return data;
    }

    public static HordeSavedData getCleanData(ServerLevel level) {
        HordeSavedData data = new HordeSavedData();
        data.level = level;
        int day = Math.round(level.m_46468_() / (long)((Integer)CommonConfigHandler.dayLength.get()).intValue());
        double multiplier = Math.ceil(day / (Integer)CommonConfigHandler.hordeSpawnDays.get());
        if (!((Boolean)CommonConfigHandler.spawnFirstDay.get()).booleanValue() || day != 0) {
            multiplier += 1.0;
        }
        int nextDay = (int)Math.floor(multiplier * (double)((Integer)CommonConfigHandler.hordeSpawnDays.get()).intValue() + (double)level.f_46441_.nextInt((Integer)CommonConfigHandler.hordeSpawnVariation.get() + 1));
        data.setNextDay(nextDay);
        return data;
    }
}

