/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.infection;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingConversionEvent;
import net.minecraftforge.eventbus.api.Event;

public class InfectionConversionEntry {
    protected final int infectChance;
    protected final EntityType<? extends LivingEntity> result;
    protected CompoundTag nbt = null;

    protected InfectionConversionEntry(int infectChance, EntityType<? extends LivingEntity> result) {
        this.infectChance = infectChance;
        this.result = result;
    }

    public LivingEntity convertEntity(LivingEntity entity) {
        LivingConversionEvent.Pre preEvent = new LivingConversionEvent.Pre(entity, this.result, i -> {});
        MinecraftForge.EVENT_BUS.post((Event)preEvent);
        Level level = entity.f_19853_;
        LivingEntity zombie = (LivingEntity)preEvent.getOutcome().m_20615_(level);
        zombie.m_6034_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            zombie.m_8061_(slot, entity.m_6844_(slot));
        }
        if (entity.m_8077_()) {
            zombie.m_6593_(entity.m_7770_());
        }
        if (zombie instanceof AgeableMob) {
            ((AgeableMob)zombie).m_146762_(entity.m_6162_() ? -1000000 : 0);
        }
        if (zombie instanceof Zombie) {
            ((Zombie)zombie).m_6863_(entity.m_6162_());
        }
        if (this.nbt != null) {
            entity.m_7378_(this.nbt);
        }
        LivingConversionEvent.Post postEvent = new LivingConversionEvent.Post(entity, zombie);
        MinecraftForge.EVENT_BUS.post((Event)postEvent);
        zombie = postEvent.getOutcome();
        level.m_7967_((Entity)zombie);
        entity.m_6074_();
        return zombie;
    }

    public int getInfectChance() {
        return this.infectChance;
    }

    public void setNBT(CompoundTag nbt) {
        this.nbt = nbt;
    }
}

