/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.infection;

import java.util.Random;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.ZombieVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.network.NetworkDirection;
import net.smileycorp.atlas.api.network.SimpleStringMessage;
import net.smileycorp.atlas.api.util.DirectionUtils;
import net.smileycorp.hordes.common.CommonConfigHandler;
import net.smileycorp.hordes.common.event.InfectionDeathEvent;
import net.smileycorp.hordes.common.infection.HordesInfection;
import net.smileycorp.hordes.common.infection.InfectionRegister;
import net.smileycorp.hordes.common.infection.network.InfectMessage;
import net.smileycorp.hordes.common.infection.network.InfectionPacketHandler;

@Mod.EventBusSubscriber(modid="hordes")
public class InfectionEventHandler {
    @SubscribeEvent
    public void onEntityAdded(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity != null && !entity.f_19853_.f_46443_ && ((Boolean)CommonConfigHandler.infectionEntitiesAggroConversions.get()).booleanValue() && InfectionRegister.canCauseInfection(entity) && entity instanceof Mob) {
            ((Mob)entity).f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)entity, LivingEntity.class, 10, true, false, InfectionRegister::canBeInfected));
        }
    }

    @SubscribeEvent
    public void playerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getPlayer();
        if (player != null && player instanceof ServerPlayer) {
            InfectionPacketHandler.NETWORK_INSTANCE.sendTo((Object)new SimpleStringMessage(InfectionRegister.getCurePacketData()), ((ServerPlayer)player).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
        }
    }

    @SubscribeEvent
    public void onItemStackConsume(LivingEntityUseItemEvent.Finish event) {
        LivingEntity entity = event.getEntityLiving();
        ItemStack stack = event.getItem();
        if (entity.m_21023_((MobEffect)HordesInfection.INFECTED.get()) && InfectionRegister.isCure(stack)) {
            entity.m_21195_((MobEffect)HordesInfection.INFECTED.get());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onItemUse(PlayerInteractEvent.RightClickItem event) {
        LivingEntity entity;
        ItemStack stack = event.getItemStack();
        HitResult ray = DirectionUtils.getEntityRayTrace((Level)event.getWorld(), (Entity)event.getPlayer(), (float)5.0f);
        if (ray instanceof EntityHitResult && ((EntityHitResult)ray).m_82443_() instanceof LivingEntity && (entity = (LivingEntity)((EntityHitResult)ray).m_82443_()).m_21023_((MobEffect)HordesInfection.INFECTED.get()) && InfectionRegister.isCure(stack)) {
            entity.m_21195_((MobEffect)HordesInfection.INFECTED.get());
            event.setCanceled(true);
            event.setCancellationResult(InteractionResult.FAIL);
        }
    }

    @SubscribeEvent
    public void onDamage(LivingDamageEvent event) {
        LivingEntity entity = event.getEntityLiving();
        Entity attacker = event.getSource().m_7640_();
        Level level = entity.f_19853_;
        Random rand = level.f_46441_;
        if (!level.f_46443_ && InfectionRegister.canCauseInfection(attacker) && !entity.m_21023_((MobEffect)HordesInfection.INFECTED.get())) {
            if (entity instanceof Player && ((Boolean)CommonConfigHandler.infectPlayers.get()).booleanValue()) {
                int c = rand.nextInt(100);
                if (c <= (Integer)CommonConfigHandler.playerInfectChance.get()) {
                    entity.m_7292_(new MobEffectInstance((MobEffect)HordesInfection.INFECTED.get(), 10000, 0));
                    InfectionPacketHandler.NETWORK_INSTANCE.sendTo((Object)new InfectMessage(), ((ServerPlayer)entity).f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
                }
            } else if (entity instanceof Villager && ((Boolean)CommonConfigHandler.infectVillagers.get()).booleanValue()) {
                int c = rand.nextInt(100);
                if (c <= (Integer)CommonConfigHandler.villagerInfectChance.get()) {
                    entity.m_7292_(new MobEffectInstance((MobEffect)HordesInfection.INFECTED.get(), 10000, 0));
                }
            } else if (InfectionRegister.canBeInfected((Entity)entity)) {
                InfectionRegister.tryToInfect(entity);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onDeath(LivingDeathEvent event) {
        LivingEntity entity = event.getEntityLiving();
        DamageSource source = event.getSource();
        Level level = entity.f_19853_;
        if (!level.f_46443_ && (source == HordesInfection.INFECTION_DAMAGE || entity.m_21023_((MobEffect)HordesInfection.INFECTED.get()))) {
            InfectionDeathEvent newevent = new InfectionDeathEvent(entity, event.getSource());
            MinecraftForge.EVENT_BUS.post((Event)newevent);
            if (newevent.getResult() == Event.Result.DENY) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public void onInfectDeath(InfectionDeathEvent event) {
        LivingEntity entity = event.getEntityLiving();
        Level level = entity.f_19853_;
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            ZombieVillager zombie = (ZombieVillager)EntityType.f_20530_.m_20615_(level);
            zombie.m_141967_(villager.m_7141_());
            zombie.m_34373_(villager.m_7809_());
            zombie.m_6034_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                zombie.m_8061_(slot, entity.m_6844_(slot));
            }
            if (entity.m_8077_()) {
                zombie.m_6593_(entity.m_7770_());
            }
            level.m_7967_((Entity)zombie);
            entity.m_6074_();
            event.setResult(Event.Result.DENY);
        } else if (InfectionRegister.canBeInfected((Entity)entity)) {
            InfectionRegister.convertEntity(entity);
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public static void onTick(LivingEvent.LivingUpdateEvent event) {
        MobEffectInstance effect;
        LivingEntity entity = event.getEntityLiving();
        Level level = entity.f_19853_;
        if (!level.f_46443_ && entity.m_21023_((MobEffect)HordesInfection.INFECTED.get()) && (effect = entity.m_21124_((MobEffect)HordesInfection.INFECTED.get())).m_19557_() < 10000 - (Integer)CommonConfigHandler.ticksForEffectStage.get()) {
            int a = effect.m_19564_();
            if (a < 3) {
                entity.m_7292_(new MobEffectInstance((MobEffect)HordesInfection.INFECTED.get(), 10000, a + 1));
            } else {
                entity.m_6469_(HordesInfection.INFECTION_DAMAGE, Float.MAX_VALUE);
            }
        }
    }
}

