/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.infection;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.registries.ForgeRegistries;
import net.smileycorp.atlas.api.util.RecipeUtils;
import net.smileycorp.hordes.common.CommonConfigHandler;
import net.smileycorp.hordes.common.CommonUtils;
import net.smileycorp.hordes.common.Hordes;
import net.smileycorp.hordes.common.infection.HordesInfection;
import net.smileycorp.hordes.common.infection.InfectionConversionEntry;
import net.smileycorp.hordes.integration.jei.JEIPluginInfection;

public class InfectionRegister {
    private static List<ItemStack> cures = new ArrayList<ItemStack>();
    private static List<ItemStack> curesClient = new ArrayList<ItemStack>();
    private static List<EntityType<?>> infectionEntities = new ArrayList();
    private static Map<EntityType<?>, InfectionConversionEntry> conversionTable = new HashMap();

    public static void readConfig() {
        InfectionRegister.readInfectionEntities();
        InfectionRegister.readCureItems();
        InfectionRegister.readEntityConversions();
    }

    private static void readInfectionEntities() {
        try {
            if (CommonConfigHandler.infectionEntities == null) {
                throw new Exception("Infection entity list has loaded as null");
            }
            if (((List)CommonConfigHandler.infectionEntities.get()).size() <= 0) {
                throw new Exception("Infection entity list in config is empty");
            }
            for (String name : (List)CommonConfigHandler.infectionEntities.get()) {
                String[] nameSplit = name.split(":");
                if (nameSplit.length >= 2) {
                    EntityType type;
                    ResourceLocation loc = new ResourceLocation(nameSplit[0], nameSplit[1]);
                    if (!ForgeRegistries.ENTITIES.containsKey(loc) || (type = (EntityType)ForgeRegistries.ENTITIES.getValue(loc)) == null) continue;
                    infectionEntities.add(type);
                    continue;
                }
                throw new Exception(name + " is not a valid registry.");
            }
        }
        catch (Exception e) {
            Hordes.logError("Failed to read config, " + e.getCause() + " " + e.getMessage(), e);
        }
    }

    private static void readCureItems() {
        try {
            if (CommonConfigHandler.cureItemList == null) {
                throw new Exception("Cure list has loaded as null");
            }
            if (((List)CommonConfigHandler.cureItemList.get()).size() <= 0) {
                throw new Exception("Cure list in config is empty");
            }
            cures = InfectionRegister.parseCureData((List)CommonConfigHandler.cureItemList.get());
        }
        catch (Exception e) {
            Hordes.logError("Failed to read config, " + e.getCause() + " " + e.getMessage(), e);
        }
    }

    private static void readEntityConversions() {
        Hordes.logInfo("Trying to read conversion table from config");
        if (CommonConfigHandler.infectionConversionList == null) {
            Hordes.logError("Error reading config.", new NullPointerException("Conversion table has loaded as null"));
        } else if (((List)CommonConfigHandler.infectionConversionList.get()).size() <= 0) {
            Hordes.logError("Error reading config.", new Exception("Conversion table in config is empty"));
        }
        for (String name : (List)CommonConfigHandler.infectionConversionList.get()) {
            try {
                EntityType type = null;
                int infectChance = 0;
                EntityType result = null;
                CompoundTag nbt = null;
                String[] nameSplit = name.split("-");
                if (nameSplit.length >= 3) {
                    ResourceLocation entity;
                    try {
                        if (nameSplit[0].contains("{")) {
                            nameSplit[0] = nameSplit[0].substring(0, nameSplit[0].indexOf("{"));
                        }
                        if (!ForgeRegistries.ENTITIES.containsKey(entity = new ResourceLocation(nameSplit[0]))) {
                            throw new Exception("Entity " + entity + " is not registered");
                        }
                        type = (EntityType)ForgeRegistries.ENTITIES.getValue(entity);
                    }
                    catch (Exception e) {
                        throw new Exception(nameSplit[0] + " is not a resourcelocation");
                    }
                    try {
                        infectChance = Integer.valueOf(nameSplit[1]);
                    }
                    catch (Exception e) {
                        throw new Exception(nameSplit[1] + " is not an integer");
                    }
                    if (nameSplit[2].contains("{")) {
                        String nbtstring = nameSplit[2].substring(nameSplit[2].indexOf("{"));
                        nameSplit[2] = nameSplit[2].substring(0, nameSplit[2].indexOf("{"));
                        nbt = CommonUtils.parseNBT(nameSplit[2], nbtstring);
                    }
                    try {
                        entity = new ResourceLocation(nameSplit[2]);
                        if (!ForgeRegistries.ENTITIES.containsKey(entity)) {
                            throw new Exception("Entity " + entity + " is not registered");
                        }
                        result = (EntityType)ForgeRegistries.ENTITIES.getValue(entity);
                    }
                    catch (Exception e) {
                        throw new Exception(nameSplit[2] + " is not a resourcelocation");
                    }
                }
                if (type == null) {
                    throw new Exception("Entry " + name + " is not in the correct format");
                }
                InfectionConversionEntry entry = new InfectionConversionEntry(infectChance, result);
                if (nbt != null) {
                    entry.setNBT(nbt);
                }
                conversionTable.put(type, entry);
                Hordes.logInfo("Loaded conversion " + name + " as " + type.toString() + " with infection chance " + infectChance + ", and converts to " + result.toString());
            }
            catch (Exception e) {
                Hordes.logError("Error adding conversion " + name + " " + e.getCause() + " " + e.getMessage(), e);
            }
        }
    }

    public static void readCurePacketData(String data) {
        try {
            curesClient = InfectionRegister.parseCureData(Lists.newArrayList((Object[])data.split(";")));
        }
        catch (Exception e) {
            Hordes.logError("Failed to read data from server, " + e.getCause() + " " + e.getMessage(), e);
        }
        if (ModList.get().isLoaded("jei")) {
            JEIPluginInfection.setRecipes(curesClient);
        }
    }

    public static String getCurePacketData() {
        StringBuilder builder = new StringBuilder();
        for (ItemStack stack : cures) {
            builder.append(stack.m_41720_().getRegistryName());
            if (stack.m_41783_() != null) {
                builder.append(stack.m_41783_().toString());
            }
            builder.append(";");
        }
        return builder.toString();
    }

    public static List<ItemStack> parseCureData(List<String> data) throws Exception {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (String name : data) {
            String[] nameSplit;
            CompoundTag nbt = null;
            if (name.contains("{")) {
                String nbtstring = name.substring(name.indexOf("{"));
                name = name.substring(0, name.indexOf("{"));
                try {
                    CompoundTag parsed = TagParser.m_129359_((String)nbtstring);
                    if (parsed != null) {
                        nbt = parsed;
                    }
                }
                catch (Exception e) {
                    Hordes.logError("Error parsing nbt for entity " + name + " " + e.getMessage(), e);
                }
            }
            if ((nameSplit = name.split(":")).length >= 2) {
                ResourceLocation loc = new ResourceLocation(nameSplit[0], nameSplit[1]);
                if (!ForgeRegistries.ITEMS.containsKey(loc)) continue;
                ItemStack stack = new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(loc));
                if (nbt != null) {
                    stack.m_41751_(nbt);
                }
                stacks.add(stack);
                continue;
            }
            throw new Exception(name + " is not a valid registry");
        }
        return stacks;
    }

    static List<ItemStack> getCureList() {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        for (ItemStack stack : Thread.currentThread().getThreadGroup() == SidedThreadGroups.CLIENT ? curesClient : cures) {
            result.add(new ItemStack((ItemLike)stack.m_41720_()));
        }
        return result;
    }

    public static void addCureItem(ItemStack stack) {
        cures.add(stack);
    }

    public static void removeCureItem(ItemStack stack) {
        for (ItemStack match : cures) {
            if (!RecipeUtils.compareItemStacks((ItemStack)match, (ItemStack)stack, (boolean)true)) continue;
            cures.remove(match);
        }
    }

    public static boolean isCure(ItemStack stack) {
        for (ItemStack cure : Thread.currentThread().getThreadGroup() == SidedThreadGroups.CLIENT ? curesClient : cures) {
            if (!RecipeUtils.compareItemStacks((ItemStack)stack, (ItemStack)cure, (cure.m_41783_() != null ? 1 : 0) != 0)) continue;
            return true;
        }
        return false;
    }

    public static boolean canCauseInfection(Entity entity) {
        if (entity instanceof Mob) {
            for (EntityType<?> type : infectionEntities) {
                if (entity.m_6095_() != type) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean canBeInfected(Entity entity) {
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        return conversionTable.containsKey(entity.m_6095_());
    }

    public static void tryToInfect(LivingEntity entity) {
        int c = entity.f_19853_.f_46441_.nextInt(100);
        if (c <= conversionTable.get(entity.m_6095_()).getInfectChance()) {
            entity.m_7292_(new MobEffectInstance((MobEffect)HordesInfection.INFECTED.get(), 10000, 0));
        }
    }

    public static void convertEntity(LivingEntity entity) {
        conversionTable.get(entity.m_6095_()).convertEntity(entity);
    }
}

