/*
 * Decompiled with CFR 0.152.
 */
package commoble.tubesreloaded;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import commoble.tubesreloaded.IsWasSprintPacket;
import commoble.tubesreloaded.Names;
import commoble.tubesreloaded.ServerConfig;
import commoble.tubesreloaded.blocks.distributor.DistributorBlock;
import commoble.tubesreloaded.blocks.distributor.DistributorBlockEntity;
import commoble.tubesreloaded.blocks.extractor.ExtractorBlock;
import commoble.tubesreloaded.blocks.filter.FilterBlock;
import commoble.tubesreloaded.blocks.filter.FilterBlockEntity;
import commoble.tubesreloaded.blocks.filter.FilterMenu;
import commoble.tubesreloaded.blocks.filter.OsmosisFilterBlock;
import commoble.tubesreloaded.blocks.filter.OsmosisFilterBlockEntity;
import commoble.tubesreloaded.blocks.filter.OsmosisSlimeBlock;
import commoble.tubesreloaded.blocks.loader.LoaderBlock;
import commoble.tubesreloaded.blocks.loader.LoaderMenu;
import commoble.tubesreloaded.blocks.shunt.ShuntBlock;
import commoble.tubesreloaded.blocks.shunt.ShuntBlockEntity;
import commoble.tubesreloaded.blocks.tube.ColoredTubeBlock;
import commoble.tubesreloaded.blocks.tube.RaytraceHelper;
import commoble.tubesreloaded.blocks.tube.RedstoneTubeBlock;
import commoble.tubesreloaded.blocks.tube.RedstoneTubeBlockEntity;
import commoble.tubesreloaded.blocks.tube.SyncTubesInChunkPacket;
import commoble.tubesreloaded.blocks.tube.TubeBlock;
import commoble.tubesreloaded.blocks.tube.TubeBlockEntity;
import commoble.tubesreloaded.blocks.tube.TubeBreakPacket;
import commoble.tubesreloaded.blocks.tube.TubesInChunk;
import commoble.tubesreloaded.blocks.tube.TubingPliersItem;
import commoble.tubesreloaded.client.ClientEvents;
import commoble.tubesreloaded.client.FakeWorldForTubeRaytrace;
import commoble.tubesreloaded.shadow.commoble.databuddy.config.ConfigHelper;
import commoble.useitemonblockevent.api.UseItemOnBlockEvent;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.level.ChunkWatchEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

@Mod(value="tubesreloaded")
public class TubesReloaded {
    public static final String MODID = "tubesreloaded";
    public static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("tubesreloaded", "main"), () -> "1", "1"::equals, "1"::equals);
    private static TubesReloaded INSTANCE;
    private final ServerConfig serverConfig;
    public final Map<DyeColor, RegistryObject<ColoredTubeBlock>> coloredTubeBlocks;
    public final RegistryObject<DistributorBlock> distributorBlock;
    public final RegistryObject<ExtractorBlock> extractorBlock;
    public final RegistryObject<FilterBlock> filterBlock;
    public final RegistryObject<LoaderBlock> loaderBlock;
    public final RegistryObject<OsmosisFilterBlock> osmosisFilterBlock;
    public final RegistryObject<OsmosisSlimeBlock> osmosisSlimeBlock;
    public final RegistryObject<RedstoneTubeBlock> redstoneTubeBlock;
    public final RegistryObject<ShuntBlock> shuntBlock;
    public final RegistryObject<TubeBlock> tubeBlock;
    public final RegistryObject<BlockItem> tubeItem;
    public final RegistryObject<TubingPliersItem> tubingPliers;
    public final RegistryObject<BlockEntityType<DistributorBlockEntity>> distributorEntity;
    public final RegistryObject<BlockEntityType<FilterBlockEntity>> filterEntity;
    public final RegistryObject<BlockEntityType<OsmosisFilterBlockEntity>> osmosisFilterEntity;
    public final RegistryObject<BlockEntityType<RedstoneTubeBlockEntity>> redstoneTubeEntity;
    public final RegistryObject<BlockEntityType<ShuntBlockEntity>> shuntEntity;
    public final RegistryObject<BlockEntityType<TubeBlockEntity>> tubeEntity;
    public final RegistryObject<MenuType<FilterMenu>> filterMenu;
    public final RegistryObject<MenuType<LoaderMenu>> loaderMenu;
    public static final CreativeModeTab TAB;

    public TubesReloaded() {
        INSTANCE = this;
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        this.serverConfig = ConfigHelper.register(ModConfig.Type.SERVER, ServerConfig::create);
        DeferredRegister blocks = TubesReloaded.makeDeferredRegister(modBus, ForgeRegistries.BLOCKS);
        DeferredRegister items = TubesReloaded.makeDeferredRegister(modBus, ForgeRegistries.ITEMS);
        DeferredRegister blockEntities = TubesReloaded.makeDeferredRegister(modBus, ForgeRegistries.BLOCK_ENTITY_TYPES);
        DeferredRegister containers = TubesReloaded.makeDeferredRegister(modBus, ForgeRegistries.MENU_TYPES);
        Material tubeMaterial = new Material.Builder(MaterialColor.f_76407_).m_76359_();
        ArrayList<Object> tubeBlocksWithTubeBlockEntity = new ArrayList<Object>();
        Pair<RegistryObject<TubeBlock>, RegistryObject<BlockItem>> tubeBlockAndItem = TubesReloaded.registerBlockAndItem(blocks, items, "tube", () -> new TubeBlock(new ResourceLocation("tubesreloaded:block/tube"), BlockBehaviour.Properties.m_60944_((Material)Material.f_76275_, (MaterialColor)MaterialColor.f_76376_).m_60978_(0.4f).m_60918_(SoundType.f_56743_)), block -> new BlockItem((Block)block, new Item.Properties().m_41491_(TAB)));
        this.tubeBlock = (RegistryObject)tubeBlockAndItem.getFirst();
        this.shuntBlock = TubesReloaded.registerBlockAndStandardItem(blocks, items, "shunt", () -> new ShuntBlock(BlockBehaviour.Properties.m_60939_((Material)tubeMaterial).m_60913_(2.0f, 6.0f).m_60918_(SoundType.f_56743_)));
        this.loaderBlock = TubesReloaded.registerBlockAndStandardItem(blocks, items, "loader", () -> new LoaderBlock(BlockBehaviour.Properties.m_60939_((Material)tubeMaterial).m_60913_(2.0f, 6.0f).m_60918_(SoundType.f_56743_)));
        this.redstoneTubeBlock = TubesReloaded.registerBlockAndStandardItem(blocks, items, "redstone_tube", () -> new RedstoneTubeBlock(new ResourceLocation("tubesreloaded:block/tube"), BlockBehaviour.Properties.m_60944_((Material)Material.f_76275_, (MaterialColor)MaterialColor.f_76366_).m_60978_(0.4f).m_60918_(SoundType.f_56743_)));
        this.extractorBlock = TubesReloaded.registerBlockAndStandardItem(blocks, items, "extractor", () -> new ExtractorBlock(BlockBehaviour.Properties.m_60939_((Material)tubeMaterial).m_60913_(2.0f, 6.0f).m_60918_(SoundType.f_56743_)));
        this.filterBlock = TubesReloaded.registerBlockAndStandardItem(blocks, items, "filter", () -> new FilterBlock(BlockBehaviour.Properties.m_60939_((Material)tubeMaterial).m_60913_(2.0f, 6.0f).m_60918_(SoundType.f_56743_)));
        this.osmosisFilterBlock = TubesReloaded.registerBlockAndStandardItem(blocks, items, "osmosis_filter", () -> new OsmosisFilterBlock(BlockBehaviour.Properties.m_60939_((Material)tubeMaterial).m_60913_(2.0f, 6.0f).m_60918_(SoundType.f_56743_)));
        this.osmosisSlimeBlock = blocks.register("osmosis_slime", () -> new OsmosisSlimeBlock(BlockBehaviour.Properties.m_60939_((Material)tubeMaterial)));
        this.distributorBlock = TubesReloaded.registerBlockAndStandardItem(blocks, items, "distributor", () -> new DistributorBlock(BlockBehaviour.Properties.m_60939_((Material)tubeMaterial).m_60913_(2.0f, 6.0f).m_60918_(SoundType.f_56743_)));
        this.coloredTubeBlocks = new EnumMap<DyeColor, RegistryObject<ColoredTubeBlock>>(DyeColor.class);
        for (DyeColor color : DyeColor.values()) {
            String name = Names.COLORED_TUBE_NAMES[color.ordinal()];
            RegistryObject<ColoredTubeBlock> block2 = TubesReloaded.registerBlockAndStandardItem(blocks, items, name, () -> new ColoredTubeBlock(new ResourceLocation(MODID, "block/" + name), color, BlockBehaviour.Properties.m_60939_((Material)Material.f_76275_).m_60978_(0.4f).m_60918_(SoundType.f_56743_)));
            this.coloredTubeBlocks.put(color, block2);
            tubeBlocksWithTubeBlockEntity.add(block2);
        }
        tubeBlocksWithTubeBlockEntity.add(this.tubeBlock);
        this.tubeItem = (RegistryObject)tubeBlockAndItem.getSecond();
        this.tubingPliers = items.register("tubing_pliers", () -> new TubingPliersItem(new Item.Properties().m_41491_(TAB).m_41503_(128)));
        this.tubeEntity = blockEntities.register("tube", () -> BlockEntityType.Builder.m_155273_(TubeBlockEntity::new, (Block[])((Block[])tubeBlocksWithTubeBlockEntity.stream().map(RegistryObject::get).toArray(TubeBlock[]::new))).m_58966_(null));
        this.shuntEntity = blockEntities.register("shunt", () -> BlockEntityType.Builder.m_155273_(ShuntBlockEntity::new, (Block[])new Block[]{(Block)this.shuntBlock.get()}).m_58966_(null));
        this.redstoneTubeEntity = blockEntities.register("redstone_tube", () -> BlockEntityType.Builder.m_155273_(RedstoneTubeBlockEntity::new, (Block[])new Block[]{(Block)this.redstoneTubeBlock.get()}).m_58966_(null));
        this.filterEntity = blockEntities.register("filter", () -> BlockEntityType.Builder.m_155273_(FilterBlockEntity::new, (Block[])new Block[]{(Block)this.filterBlock.get()}).m_58966_(null));
        this.osmosisFilterEntity = blockEntities.register("osmosis_filter", () -> BlockEntityType.Builder.m_155273_(OsmosisFilterBlockEntity::new, (Block[])new Block[]{(Block)this.osmosisFilterBlock.get()}).m_58966_(null));
        this.distributorEntity = blockEntities.register("distributor", () -> BlockEntityType.Builder.m_155273_(DistributorBlockEntity::new, (Block[])new Block[]{(Block)this.distributorBlock.get()}).m_58966_(null));
        this.loaderMenu = containers.register("loader", () -> new MenuType(LoaderMenu::new));
        this.filterMenu = containers.register("filter", () -> new MenuType(FilterMenu::createClientMenu));
        modBus.addListener(this::onCommonSetup);
        modBus.addListener(this::onRegisterCapabilities);
        forgeBus.addGenericListener(LevelChunk.class, this::onAttachChunkCapabilities);
        forgeBus.addListener(this::onUseItemOnBlock);
        forgeBus.addListener(this::onChunkWatch);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            ClientEvents.subscribeClientEvents(modBus, forgeBus);
        }
    }

    public static TubesReloaded get() {
        return INSTANCE;
    }

    public ServerConfig serverConfig() {
        return this.serverConfig;
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        int packetID = 0;
        CHANNEL.registerMessage(packetID++, IsWasSprintPacket.class, IsWasSprintPacket::write, IsWasSprintPacket::read, IsWasSprintPacket::handle);
        CHANNEL.registerMessage(packetID++, TubeBreakPacket.class, TubeBreakPacket::write, TubeBreakPacket::read, TubeBreakPacket::handle);
        CHANNEL.registerMessage(packetID++, SyncTubesInChunkPacket.class, SyncTubesInChunkPacket::write, SyncTubesInChunkPacket::read, SyncTubesInChunkPacket::handle);
    }

    private void onRegisterCapabilities(RegisterCapabilitiesEvent event) {
        event.register(TubesInChunk.class);
    }

    private void onAttachChunkCapabilities(AttachCapabilitiesEvent<LevelChunk> event) {
        TubesInChunk tubesInChunk = new TubesInChunk((LevelChunk)event.getObject());
        event.addCapability(new ResourceLocation(MODID, "tubes_in_chunk"), (ICapabilityProvider)tubesInChunk);
        event.addListener(tubesInChunk::onCapabilityInvalidated);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void onUseItemOnBlock(UseItemOnBlockEvent event) {
        block3: {
            Item item;
            UseOnContext useContext = event.getUseOnContext();
            ItemStack stack = useContext.m_43722_();
            if (event.getUsePhase() != UseItemOnBlockEvent.UsePhase.POST_BLOCK || !((item = stack.m_41720_()) instanceof BlockItem)) break block3;
            BlockItem blockItem = (BlockItem)item;
            Level level = useContext.m_43725_();
            BlockPlaceContext placeContext = new BlockPlaceContext(useContext);
            BlockPos placePos = placeContext.m_8083_();
            BlockState placementState = blockItem.m_5965_(placeContext);
            if (placementState == null) break block3;
            Set<ChunkPos> chunkPositions = TubesInChunk.getRelevantChunkPositionsNearPos(placePos);
            for (ChunkPos chunkPos : chunkPositions) {
                HashSet<BlockPos> checkedTubePositions = new HashSet<BlockPos>();
                for (BlockPos tubePos : TubesInChunk.getTubesInChunkIfLoaded((LevelAccessor)level, chunkPos)) {
                    Player player;
                    block6: {
                        block4: {
                            Vec3 hit;
                            block5: {
                                BlockEntity blockEntity = level.m_7702_(tubePos);
                                if (!(blockEntity instanceof TubeBlockEntity)) continue;
                                TubeBlockEntity tube = (TubeBlockEntity)blockEntity;
                                hit = RaytraceHelper.doesBlockStateIntersectTubeConnections(tube.m_58899_(), placePos, new FakeWorldForTubeRaytrace((BlockGetter)level, placePos, placementState), placementState, checkedTubePositions, tube.getRemoteConnections());
                                if (hit == null) break block4;
                                player = placeContext.m_43723_();
                                if (!(player instanceof ServerPlayer)) break block5;
                                ServerPlayer serverPlayer = (ServerPlayer)player;
                                if (!(level instanceof ServerLevel)) break block5;
                                ServerLevel serverLevel = (ServerLevel)level;
                                serverPlayer.f_8906_.m_9829_((Packet)new ClientboundSetEquipmentPacket(serverPlayer.m_19879_(), (List)ImmutableList.of((Object)Pair.of((Object)EquipmentSlot.MAINHAND, (Object)serverPlayer.m_21120_(InteractionHand.MAIN_HAND)))));
                                serverLevel.m_8624_(serverPlayer, (ParticleOptions)DustParticleOptions.f_123656_, false, hit.f_82479_, hit.f_82480_, hit.f_82481_, 5, 0.05, 0.05, 0.05, 0.0);
                                break block6;
                            }
                            if (!level.f_46443_) break block6;
                            level.m_7106_((ParticleOptions)DustParticleOptions.f_123656_, hit.f_82479_, hit.f_82480_, hit.f_82481_, 0.05, 0.05, 0.05);
                            break block6;
                        }
                        checkedTubePositions.add(tubePos);
                        continue;
                    }
                    if (player != null) {
                        player.m_6330_(SoundEvents.f_12587_, SoundSource.BLOCKS, 0.5f, 2.0f);
                    }
                    event.cancelWithResult(InteractionResult.SUCCESS);
                    return;
                }
            }
        }
    }

    private void onChunkWatch(ChunkWatchEvent.Watch event) {
        LevelChunk chunk = event.getChunk();
        ServerPlayer player = event.getPlayer();
        ChunkPos pos = chunk.m_7697_();
        chunk.getCapability(TubesInChunk.CAPABILITY).ifPresent(cap -> CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new SyncTubesInChunkPacket(pos, cap.getPositions())));
    }

    private static <T> DeferredRegister<T> makeDeferredRegister(IEventBus modBus, IForgeRegistry<T> registry) {
        DeferredRegister register = DeferredRegister.create(registry, (String)MODID);
        register.register(modBus);
        return register;
    }

    private static <BLOCK extends Block, ITEM extends BlockItem> Pair<RegistryObject<BLOCK>, RegistryObject<ITEM>> registerBlockAndItem(DeferredRegister<Block> blocks, DeferredRegister<Item> items, String name, Supplier<BLOCK> blockFactory, Function<? super BLOCK, ITEM> itemFactory) {
        RegistryObject block = blocks.register(name, blockFactory);
        RegistryObject item = items.register(name, () -> (BlockItem)itemFactory.apply((Object)block.get()));
        return Pair.of((Object)block, (Object)item);
    }

    private static <BLOCK extends Block> RegistryObject<BLOCK> registerBlockAndStandardItem(DeferredRegister<Block> blocks, DeferredRegister<Item> items, String name, Supplier<BLOCK> blockFactory) {
        return (RegistryObject)TubesReloaded.registerBlockAndItem(blocks, items, name, blockFactory, block -> new BlockItem(block, new Item.Properties().m_41491_(TAB))).getFirst();
    }

    static {
        TAB = new CreativeModeTab(MODID){

            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)TubesReloaded.get().tubeItem.get());
            }
        };
    }

    public static class Tags {

        public static class Items {
            public static final TagKey<Item> COLORED_TUBES = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation("tubesreloaded", "colored_tubes"));
            public static final TagKey<Item> TUBES = TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation("tubesreloaded", "tubes"));
        }

        public static class Blocks {
            public static final TagKey<Block> COLORED_TUBES = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation("tubesreloaded", "colored_tubes"));
            public static final TagKey<Block> TUBES = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation("tubesreloaded", "tubes"));
            public static final TagKey<Block> ROTATABLE_BY_PLIERS = TagKey.m_203882_((ResourceKey)Registry.f_122901_, (ResourceLocation)new ResourceLocation("tubesreloaded", "rotatable_by_pliers"));
        }
    }
}

