/*
 * Decompiled with CFR 0.152.
 */
package commoble.tubesreloaded.blocks.distributor;

import commoble.tubesreloaded.TubesReloaded;
import commoble.tubesreloaded.blocks.distributor.DistributorItemHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;

public class DistributorBlockEntity
extends BlockEntity {
    public static final String NEXT_DIRECTIONS = "next_directions";
    protected final DistributorItemHandler[] handlers = (DistributorItemHandler[])IntStream.range(0, 6).mapToObj(i -> new DistributorItemHandler(this, Direction.m_122376_((int)i))).toArray(DistributorItemHandler[]::new);
    public final List<LazyOptional<DistributorItemHandler>> handlerOptionals = Arrays.stream(this.handlers).map(handler -> LazyOptional.of(() -> handler)).collect(Collectors.toCollection(ArrayList::new));
    public Direction nextSide = Direction.DOWN;

    public DistributorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public DistributorBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TubesReloaded.get().distributorEntity.get(), pos, state);
    }

    public List<LazyOptional<DistributorItemHandler>> initItemHandlers() {
        return IntStream.range(0, 6).mapToObj(i -> LazyOptional.of(() -> new DistributorItemHandler(this, Direction.m_122376_((int)i)))).collect(Collectors.toCollection(ArrayList::new));
    }

    public void invalidateCaps() {
        this.handlerOptionals.forEach(LazyOptional::invalidate);
        super.invalidateCaps();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handlerOptionals.get(side.ordinal()).cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_183515_(CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128385_(NEXT_DIRECTIONS, IntStream.range(0, 6).map(i -> this.handlers[i].getNextDirectionIndex()).toArray());
    }

    public void m_142466_(CompoundTag nbt) {
        int[] directionIndices = nbt.m_128465_(NEXT_DIRECTIONS);
        int maxSize = Math.min(this.handlers.length, directionIndices.length);
        for (int i = 0; i < maxSize; ++i) {
            this.handlers[i].setNextDirectionIndex(directionIndices[i]);
        }
        super.m_142466_(nbt);
    }
}

