/*
 * Decompiled with CFR 0.152.
 */
package commoble.tubesreloaded.blocks.distributor;

import commoble.tubesreloaded.blocks.distributor.DistributorBlockEntity;
import commoble.tubesreloaded.util.WorldHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class DistributorItemHandler
implements IItemHandler {
    protected final DistributorBlockEntity distributor;
    private final Direction inputFace;
    private Direction nextDirection = Direction.DOWN;
    private boolean shunting = false;

    public DistributorItemHandler(DistributorBlockEntity distributor, Direction inputFace) {
        this.distributor = distributor;
        this.inputFace = inputFace;
    }

    public int getNextDirectionIndex() {
        return this.nextDirection.ordinal();
    }

    public void setNextDirectionIndex(int index) {
        this.nextDirection = Direction.m_122376_((int)index);
        this.distributor.m_6596_();
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        return ItemStack.f_41583_;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (this.shunting) {
            return stack.m_41777_();
        }
        if (!simulate && !stack.m_41619_()) {
            int startCheckIndex = this.nextDirection.ordinal();
            int checkIndex = 0;
            ItemStack remainingStack = stack;
            for (int i = 0; i < 6; ++i) {
                checkIndex = (i + startCheckIndex) % 6;
                Direction checkDirection = Direction.m_122376_((int)checkIndex);
                if (checkDirection == this.inputFace) continue;
                BlockPos outputPos = this.distributor.m_58899_().m_121945_(checkDirection);
                ItemStack stackForNextInsertion = remainingStack.m_41777_();
                this.shunting = true;
                remainingStack = this.getOutputOptional(outputPos, checkDirection).map(handler -> WorldHelper.disperseItemToHandler(stackForNextInsertion, handler, simulate)).orElse(remainingStack);
                this.shunting = false;
                if (remainingStack.m_41619_()) break;
            }
            if (!remainingStack.m_41619_()) {
                WorldHelper.ejectItemstack(this.distributor.m_58904_(), this.distributor.m_58899_(), this.inputFace.m_122424_(), remainingStack);
            }
            this.setNextDirectionIndex((checkIndex + 1) % 6);
        }
        return ItemStack.f_41583_;
    }

    private LazyOptional<IItemHandler> getOutputOptional(BlockPos outputPos, Direction outputDir) {
        return WorldHelper.getItemHandlerAt(this.distributor.m_58904_(), outputPos, outputDir.m_122424_());
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return true;
    }
}

