/*
 * Decompiled with CFR 0.152.
 */
package commoble.tubesreloaded.blocks.extractor;

import commoble.tubesreloaded.util.WorldHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class ExtractorBlock
extends Block {
    public static final DirectionProperty FACING = DirectionalBlock.f_52588_;
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    protected final VoxelShape[] shapes;

    public ExtractorBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.DOWN)).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        this.shapes = this.makeShapes();
    }

    public void m_6861_(BlockState thisState, Level level, BlockPos thisPos, Block neighborBlock, BlockPos neighborPos, boolean isMoving) {
        boolean isStatePowered;
        boolean isReceivingPower;
        if (!level.m_5776_() && (isReceivingPower = level.m_46753_(thisPos)) != (isStatePowered = ((Boolean)thisState.m_61143_((Property)POWERED)).booleanValue())) {
            if (isReceivingPower) {
                this.transferItem(thisState, thisPos, level);
                level.m_5594_(null, thisPos, SoundEvents.f_12311_, SoundSource.BLOCKS, 0.3f, level.f_46441_.m_188501_() * 0.1f + 0.8f);
            } else {
                level.m_5594_(null, thisPos, SoundEvents.f_12312_, SoundSource.BLOCKS, 0.1f, level.f_46441_.m_188501_() * 0.1f + 0.9f);
            }
            level.m_7731_(thisPos, (BlockState)thisState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(isReceivingPower)), 2);
        }
    }

    private void transferItem(BlockState state, BlockPos pos, Level level) {
        ItemStack stack;
        LazyOptional<IItemHandler> outputCap;
        Direction outputDir = (Direction)state.m_61143_((Property)FACING);
        BlockPos outputPos = pos.m_121945_(outputDir);
        Direction inputDir = outputDir.m_122424_();
        BlockPos inputPos = pos.m_121945_(inputDir);
        LazyOptional<IItemHandler> inputCap = WorldHelper.getItemHandlerAt(level, inputPos, outputDir);
        if (inputCap.isPresent() && ((outputCap = WorldHelper.getItemHandlerAt(level, outputPos, inputDir)).isPresent() || !level.m_8055_(outputPos).m_60838_((BlockGetter)level, outputPos)) && (stack = inputCap.map(inputHandler -> this.extractNextStack((IItemHandler)inputHandler)).orElse(ItemStack.f_41583_)).m_41613_() > 0) {
            ItemStack remaining = outputCap.map(outputHandler -> this.putStackInHandler(stack, (IItemHandler)outputHandler)).orElse(stack.m_41777_());
            WorldHelper.ejectItemstack(level, pos, outputDir, remaining);
        }
    }

    private ItemStack extractNextStack(IItemHandler handler) {
        int slots = handler.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack stack = handler.extractItem(i, 64, false);
            if (stack.m_41613_() <= 0) continue;
            return stack.m_41777_();
        }
        return ItemStack.f_41583_;
    }

    private ItemStack putStackInHandler(ItemStack stack, IItemHandler handler) {
        ItemStack remaining = stack.m_41777_();
        int slots = handler.getSlots();
        for (int i = 0; i < slots; ++i) {
            if ((remaining = handler.insertItem(i, remaining, false)).m_41613_() > 0) continue;
            return ItemStack.f_41583_;
        }
        return remaining;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)WorldHelper.getBlockFacingForPlacement(context).m_122424_());
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Deprecated
    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POWERED});
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return this.shapes[this.getShapeIndex(state)];
    }

    public int getShapeIndex(BlockState state) {
        return ((Direction)state.m_61143_((Property)FACING)).ordinal();
    }

    protected VoxelShape[] makeShapes() {
        VoxelShape[] shapes = new VoxelShape[6];
        for (int face = 0; face < 6; ++face) {
            double output_z_min;
            double output_y_max;
            double output_y_min;
            double output_x_max;
            double output_x_min;
            double mid_z_max;
            boolean DOWN = face == 0;
            boolean UP = face == 1;
            boolean NORTH = face == 2;
            boolean SOUTH = face == 3;
            boolean WEST = face == 4;
            boolean EAST = face == 5;
            double input_x_min = WEST ? 10.0 : 0.0;
            double input_x_max = EAST ? 6.0 : 16.0;
            double input_y_min = DOWN ? 10.0 : 0.0;
            double input_y_max = UP ? 6.0 : 16.0;
            double input_z_min = NORTH ? 10.0 : 0.0;
            double input_z_max = SOUTH ? 6.0 : 16.0;
            double mid_x_min = EAST ? 6.0 : 4.0;
            double mid_x_max = WEST ? 10.0 : 12.0;
            double mid_y_min = UP ? 6.0 : 4.0;
            double mid_y_max = DOWN ? 10.0 : 12.0;
            double mid_z_min = SOUTH ? 6.0 : 4.0;
            double d = mid_z_max = NORTH ? 10.0 : 12.0;
            double d2 = WEST ? 0.0 : (output_x_min = EAST ? 12.0 : 6.0);
            double d3 = WEST ? 4.0 : (output_x_max = EAST ? 16.0 : 10.0);
            double d4 = DOWN ? 0.0 : (output_y_min = UP ? 12.0 : 6.0);
            double d5 = DOWN ? 4.0 : (output_y_max = UP ? 16.0 : 10.0);
            double d6 = SOUTH ? 12.0 : (output_z_min = NORTH ? 0.0 : 6.0);
            double output_z_max = SOUTH ? 16.0 : (NORTH ? 4.0 : 10.0);
            VoxelShape input = Block.m_49796_((double)input_x_min, (double)input_y_min, (double)input_z_min, (double)input_x_max, (double)input_y_max, (double)input_z_max);
            VoxelShape mid = Block.m_49796_((double)mid_x_min, (double)mid_y_min, (double)mid_z_min, (double)mid_x_max, (double)mid_y_max, (double)mid_z_max);
            VoxelShape output = Block.m_49796_((double)output_x_min, (double)output_y_min, (double)output_z_min, (double)output_x_max, (double)output_y_max, (double)output_z_max);
            shapes[face] = Shapes.m_83124_((VoxelShape)input, (VoxelShape[])new VoxelShape[]{mid, output});
        }
        return shapes;
    }
}

