/*
 * Decompiled with CFR 0.152.
 */
package commoble.tubesreloaded.blocks.filter;

import commoble.tubesreloaded.TubesReloaded;
import commoble.tubesreloaded.blocks.filter.FilterBlockEntity;
import commoble.tubesreloaded.blocks.filter.FilterMenu;
import commoble.tubesreloaded.util.WorldHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.network.NetworkHooks;

public class FilterBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = DirectionalBlock.f_52588_;
    public static final VoxelShape[] SHAPES = FilterBlock.makeShapes();

    public FilterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof FilterBlockEntity) {
                FilterBlockEntity filter = (FilterBlockEntity)blockEntity;
                NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new SimpleMenuProvider(FilterMenu.createServerMenuConstructor(filter), (Component)Component.m_237115_((String)this.m_7705_())));
            }
        }
        return InteractionResult.SUCCESS;
    }

    @Deprecated
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        BlockEntity blockEntity;
        if (!level.m_5776_() && !state.m_60713_(newState.m_60734_()) && (blockEntity = level.m_7702_(pos)) instanceof FilterBlockEntity) {
            FilterBlockEntity filter = (FilterBlockEntity)blockEntity;
            filter.dropItems();
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)WorldHelper.getBlockFacingForPlacement(context));
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    @Deprecated
    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state.m_60717_(mirrorIn.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    public static VoxelShape[] makeShapes() {
        VoxelShape[] shapes = new VoxelShape[6];
        for (int face = 0; face < 6; ++face) {
            boolean DOWN = face == 0;
            boolean UP = face == 1;
            boolean NORTH = face == 2;
            boolean SOUTH = face == 3;
            boolean WEST = face == 4;
            boolean EAST = face == 5;
            double x_min = WEST ? 14.0 : 0.0;
            double x_max = EAST ? 2.0 : 16.0;
            double y_min = DOWN ? 14.0 : 0.0;
            double y_max = UP ? 2.0 : 16.0;
            double z_min = NORTH ? 14.0 : 0.0;
            double z_max = SOUTH ? 2.0 : 16.0;
            VoxelShape plate = Block.m_49796_((double)x_min, (double)y_min, (double)z_min, (double)x_max, (double)y_max, (double)z_max);
            double d = WEST ? 0.0 : (x_min = EAST ? 0.0 : 6.0);
            x_max = WEST ? 16.0 : (EAST ? 16.0 : 10.0);
            y_min = 0.0;
            y_max = 16.0;
            double d2 = WEST ? 6.0 : (z_min = EAST ? 6.0 : 0.0);
            z_max = WEST ? 10.0 : (EAST ? 10.0 : 16.0);
            VoxelShape vertical = Block.m_49796_((double)x_min, (double)y_min, (double)z_min, (double)x_max, (double)y_max, (double)z_max);
            x_min = 0.0;
            x_max = 16.0;
            double d3 = UP ? 0.0 : (y_min = DOWN ? 0.0 : 6.0);
            double d4 = UP ? 16.0 : (y_max = DOWN ? 16.0 : 10.0);
            double d5 = UP ? 6.0 : (z_min = DOWN ? 6.0 : 0.0);
            z_max = UP ? 10.0 : (DOWN ? 10.0 : 16.0);
            VoxelShape horizontal = Block.m_49796_((double)x_min, (double)y_min, (double)z_min, (double)x_max, (double)y_max, (double)z_max);
            shapes[face] = Shapes.m_83124_((VoxelShape)plate, (VoxelShape[])new VoxelShape[]{vertical, horizontal});
        }
        return shapes;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES[this.getShapeIndex(state)];
    }

    public int getShapeIndex(BlockState state) {
        return ((Direction)state.m_61143_((Property)FACING)).ordinal();
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)TubesReloaded.get().filterEntity.get()).m_155264_(pos, state);
    }
}

