/*
 * Decompiled with CFR 0.152.
 */
package commoble.tubesreloaded.blocks.filter;

import commoble.tubesreloaded.TubesReloaded;
import commoble.tubesreloaded.blocks.filter.FilterShuntingItemHandler;
import commoble.tubesreloaded.blocks.filter.FilterStorageItemHandler;
import commoble.tubesreloaded.blocks.shunt.ShuntBlock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class FilterBlockEntity
extends BlockEntity {
    public static final String INV_KEY = "inventory";
    public ItemStack filterStack = ItemStack.f_41583_;
    public FilterShuntingItemHandler shuntingHandler = new FilterShuntingItemHandler(this);
    public FilterStorageItemHandler storageHandler = new FilterStorageItemHandler(this);
    private LazyOptional<IItemHandler> shuntingOptional = LazyOptional.of(() -> this.shuntingHandler);
    private LazyOptional<IItemHandler> storageOptional = LazyOptional.of(() -> this.storageHandler);

    public FilterBlockEntity(BlockEntityType<?> teType, BlockPos pos, BlockState state) {
        super(teType, pos, state);
    }

    public FilterBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TubesReloaded.get().filterEntity.get(), pos, state);
    }

    public void invalidateCaps() {
        this.shuntingOptional.invalidate();
        this.storageOptional.invalidate();
        super.invalidateCaps();
    }

    public boolean canItemPassThroughFilter(ItemStack stack) {
        if (stack.m_41613_() <= 0) {
            return false;
        }
        if (this.filterStack.m_41613_() <= 0) {
            return true;
        }
        return this.filterStack.m_41720_().equals(stack.m_41720_());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            Direction output_dir = (Direction)this.m_58900_().m_61143_((Property)ShuntBlock.FACING);
            if (side == output_dir.m_122424_()) {
                return this.shuntingOptional.cast();
            }
            if (side != output_dir) {
                return this.storageOptional.cast();
            }
        }
        return super.getCapability(cap, side);
    }

    public void setFilterStackAndSaveAndSync(ItemStack filterStack) {
        this.filterStack = filterStack;
        this.m_6596_();
        BlockState state = this.m_58900_();
        this.m_58904_().m_7260_(this.m_58899_(), state, state, 2);
    }

    public void dropItems() {
        BlockPos thisPos = this.m_58899_();
        Containers.m_18992_((Level)this.m_58904_(), (double)thisPos.m_123341_(), (double)thisPos.m_123342_(), (double)thisPos.m_123343_(), (ItemStack)this.filterStack);
    }

    protected void writeData(CompoundTag compound) {
        CompoundTag inventory = new CompoundTag();
        this.filterStack.m_41739_(inventory);
        compound.m_128365_(INV_KEY, (Tag)inventory);
    }

    protected void readData(CompoundTag compound) {
        CompoundTag inventory = compound.m_128469_(INV_KEY);
        this.filterStack = ItemStack.m_41712_((CompoundTag)inventory);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.writeData(compound);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.readData(compound);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = super.m_5995_();
        this.writeData(tag);
        return tag;
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }
}

