/*
 * Decompiled with CFR 0.152.
 */
package commoble.tubesreloaded.blocks.filter;

import commoble.tubesreloaded.blocks.filter.FilterBlock;
import commoble.tubesreloaded.blocks.filter.FilterBlockEntity;
import commoble.tubesreloaded.util.WorldHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class FilterShuntingItemHandler
implements IItemHandler {
    private final FilterBlockEntity filter;
    private boolean shunting = false;
    private LazyOptional<IItemHandler> targetInventory = LazyOptional.empty();

    public FilterShuntingItemHandler(FilterBlockEntity filter) {
        this.filter = filter;
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        return ItemStack.f_41583_;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (this.shunting || !this.isItemValid(slot, stack)) {
            return stack.m_41777_();
        }
        if (!simulate) {
            BlockPos pos = this.filter.m_58899_();
            Direction outputDir = (Direction)this.filter.m_58900_().m_61143_((Property)FilterBlock.FACING);
            BlockPos outputPos = pos.m_121945_(outputDir);
            this.shunting = true;
            ItemStack remaining = this.getOutputOptional(outputPos, outputDir).map(handler -> WorldHelper.disperseItemToHandler(stack, handler)).orElse(stack.m_41777_());
            this.shunting = false;
            if (remaining.m_41613_() > 0) {
                WorldHelper.ejectItemstack(this.filter.m_58904_(), pos, outputDir, remaining);
            }
        }
        return ItemStack.f_41583_;
    }

    private LazyOptional<IItemHandler> getOutputOptional(BlockPos outputPos, Direction outputDir) {
        if (!this.targetInventory.isPresent()) {
            this.targetInventory = WorldHelper.getItemHandlerAt(this.filter.m_58904_(), outputPos, outputDir.m_122424_());
        }
        return this.targetInventory;
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return stack.m_41613_() > 0 && this.filter.canItemPassThroughFilter(stack);
    }
}

