/*
 * Decompiled with CFR 0.152.
 */
package commoble.tubesreloaded.blocks.filter;

import commoble.tubesreloaded.TubesReloaded;
import commoble.tubesreloaded.blocks.filter.FilterBlock;
import commoble.tubesreloaded.blocks.filter.OsmosisFilterBlockEntity;
import commoble.tubesreloaded.util.WorldHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.items.CapabilityItemHandler;

public class OsmosisFilterBlock
extends FilterBlock {
    public static final BooleanProperty TRANSFERRING_ITEMS = BlockStateProperties.f_61431_;

    public OsmosisFilterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)TRANSFERRING_ITEMS, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{TRANSFERRING_ITEMS});
    }

    @Override
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)TubesReloaded.get().osmosisFilterEntity.get()).m_155264_(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (!level.f_46443_ && type == TubesReloaded.get().osmosisFilterEntity.get()) {
            return OsmosisFilterBlockEntity.SERVER_TICKER;
        }
        return super.m_142354_(level, state, type);
    }

    public void m_6807_(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.m_60734_() != state.m_60734_()) {
            this.updateState(level, pos, state);
        }
    }

    private void updateState(Level level, BlockPos pos, BlockState state) {
        if (!level.m_5776_()) {
            OsmosisFilterBlockEntity filter;
            boolean checkedItemsThisTick;
            boolean hasRedstoneSignal = level.m_46753_(pos);
            boolean active = (Boolean)state.m_61143_((Property)TRANSFERRING_ITEMS);
            Direction outputDirection = (Direction)state.m_61143_((Property)FACING);
            Direction inputDirection = outputDirection.m_122424_();
            BlockEntity blockEntity = level.m_7702_(pos);
            if (blockEntity instanceof OsmosisFilterBlockEntity && !(checkedItemsThisTick = (filter = (OsmosisFilterBlockEntity)blockEntity).getCheckedItemsAndMarkChecked())) {
                boolean canExtractItems;
                BlockEntity neighborBe = level.m_7702_(pos.m_121945_(inputDirection));
                boolean bl = canExtractItems = neighborBe != null && neighborBe.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, outputDirection).map(handler -> WorldHelper.doesItemHandlerHaveAnyExtractableItems(handler, filter::canItemPassThroughFilter)).orElse(false) != false;
                if (active && (hasRedstoneSignal || !canExtractItems)) {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)TRANSFERRING_ITEMS, (Comparable)Boolean.valueOf(false)), 6);
                } else if (!active && !hasRedstoneSignal && canExtractItems) {
                    level.m_7731_(pos, (BlockState)state.m_61124_((Property)TRANSFERRING_ITEMS, (Comparable)Boolean.valueOf(true)), 6);
                }
            }
        }
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        InteractionResult result = super.m_6227_(state, level, pos, player, hand, hit);
        this.updateState(level, pos, state);
        return result;
    }

    @Deprecated
    public void m_6861_(BlockState thisState, Level level, BlockPos thisPos, Block neighborBlock, BlockPos neighborPos, boolean isMoving) {
        super.m_6861_(thisState, level, thisPos, neighborBlock, neighborPos, isMoving);
        this.updateState(level, thisPos, thisState);
    }

    public void onNeighborChange(BlockState state, LevelReader levelReader, BlockPos thisPos, BlockPos neighborPos) {
        super.onNeighborChange(state, levelReader, thisPos, neighborPos);
        if (levelReader instanceof Level) {
            Level level = (Level)levelReader;
            this.updateState(level, thisPos, state);
        }
    }
}

