/*
 * Decompiled with CFR 0.152.
 */
package commoble.tubesreloaded.blocks.filter;

import com.mojang.datafixers.util.Pair;
import commoble.tubesreloaded.TubesReloaded;
import commoble.tubesreloaded.blocks.filter.FilterBlock;
import commoble.tubesreloaded.blocks.filter.FilterBlockEntity;
import commoble.tubesreloaded.blocks.filter.OsmosisFilterBlock;
import commoble.tubesreloaded.util.WorldHelper;
import java.util.stream.IntStream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandler;

public class OsmosisFilterBlockEntity
extends FilterBlockEntity {
    public static final BlockEntityTicker<OsmosisFilterBlockEntity> SERVER_TICKER = (level, pos, state, filter) -> filter.serverTick();
    public long transferHash;
    public boolean checkedItemsThisTick = false;

    public OsmosisFilterBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public OsmosisFilterBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TubesReloaded.get().osmosisFilterEntity.get(), pos, state);
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.transferHash = this.m_58899_().hashCode();
    }

    public boolean getCheckedItemsAndMarkChecked() {
        boolean checked = this.checkedItemsThisTick;
        this.checkedItemsThisTick = true;
        return checked;
    }

    protected void serverTick() {
        if (!this.f_58857_.m_5776_()) {
            this.checkedItemsThisTick = false;
            if ((this.f_58857_.m_46467_() + this.transferHash) % (long)((Integer)TubesReloaded.get().serverConfig().osmosisFilterTransferRate().get()).intValue() == 0L && ((Boolean)this.m_58900_().m_61143_((Property)OsmosisFilterBlock.TRANSFERRING_ITEMS)).booleanValue()) {
                Direction filterOutputDirection = (Direction)this.m_58900_().m_61143_((Property)FilterBlock.FACING);
                Direction filterInputDirection = filterOutputDirection.m_122424_();
                boolean successfulTransfer = WorldHelper.getItemHandlerAt(this.f_58857_, this.f_58858_.m_121945_(filterInputDirection), filterOutputDirection).map(inventory -> this.getFirstValidItem((IItemHandler)inventory)).map(stack -> this.attemptExtractionAndReturnSuccess((ItemStack)stack)).orElse(false);
                if (!successfulTransfer) {
                    this.f_58857_.m_46597_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)OsmosisFilterBlock.TRANSFERRING_ITEMS, (Comparable)Boolean.valueOf(false)));
                } else {
                    this.f_58857_.m_5594_(null, this.f_58858_, SoundEvents.f_12392_, SoundSource.BLOCKS, this.f_58857_.f_46441_.m_188501_() * 0.1f, this.f_58857_.f_46441_.m_188501_());
                }
            }
        }
    }

    private boolean attemptExtractionAndReturnSuccess(ItemStack stack) {
        if (stack.m_41613_() > 0) {
            this.shuntingHandler.insertItem(0, stack, false);
            return true;
        }
        return false;
    }

    public ItemStack getFirstValidItem(IItemHandler inventory) {
        return IntStream.range(0, inventory.getSlots()).mapToObj(slotIndex -> Pair.of((Object)slotIndex, (Object)inventory.getStackInSlot(slotIndex))).filter(slot -> this.canItemPassThroughFilter((ItemStack)slot.getSecond())).findFirst().map(slot -> inventory.extractItem(((Integer)slot.getFirst()).intValue(), 1, false)).orElse(ItemStack.f_41583_);
    }
}

