/*
 * Decompiled with CFR 0.152.
 */
package commoble.tubesreloaded.blocks.shunt;

import commoble.tubesreloaded.blocks.shunt.ShuntBlock;
import commoble.tubesreloaded.blocks.shunt.ShuntBlockEntity;
import commoble.tubesreloaded.util.WorldHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;

public class ShuntItemHandler
implements IItemHandler {
    public final ShuntBlockEntity shunt;
    public final boolean canTakeItems;
    private boolean shunting = false;

    public ShuntItemHandler(ShuntBlockEntity shunt, boolean canTakeItems) {
        this.shunt = shunt;
        this.canTakeItems = canTakeItems;
    }

    public int getSlots() {
        return 1;
    }

    public ItemStack getStackInSlot(int slot) {
        return ItemStack.f_41583_;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (!this.canTakeItems) {
            return stack.m_41777_();
        }
        if (!simulate) {
            BlockPos shuntPos = this.shunt.m_58899_();
            Direction outputDir = (Direction)this.shunt.m_58900_().m_61143_((Property)ShuntBlock.FACING);
            BlockPos outputPos = shuntPos.m_121945_(outputDir);
            if (!this.shunting) {
                this.shunting = true;
                ItemStack remaining = this.getOutputOptional(outputPos, outputDir).map(handler -> WorldHelper.disperseItemToHandler(stack, handler)).orElseGet(() -> stack.m_41777_());
                this.shunting = false;
                if (remaining.m_41613_() > 0) {
                    WorldHelper.ejectItemstack(this.shunt.m_58904_(), shuntPos, outputDir, remaining);
                }
            } else {
                WorldHelper.ejectItemstack(this.shunt.m_58904_(), shuntPos, outputDir, stack.m_41777_());
            }
        }
        return ItemStack.f_41583_;
    }

    private LazyOptional<IItemHandler> getOutputOptional(BlockPos outputPos, Direction outputDir) {
        return WorldHelper.getItemHandlerAt(this.shunt.m_58904_(), outputPos, outputDir.m_122424_());
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        return 64;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        Level world = this.shunt.m_58904_();
        BlockPos pos = this.shunt.m_58899_();
        return this.canTakeItems && !world.m_46753_(pos);
    }
}

