/*
 * Decompiled with CFR 0.152.
 */
package commoble.tubesreloaded.blocks.tube;

import com.mojang.math.OctahedralGroup;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Queue;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;

public class ItemInTubeWrapper {
    public ItemStack stack;
    public LinkedList<Direction> remainingMoves;
    public int maximumDurationInTube;
    public int ticksElapsed;
    public boolean freshlyInserted = false;
    public static final String MOVES_REMAINING_TAG = "moves";
    public static final String TICKS_REMAINING_TAG = "ticksRemaining";
    public static final String TICKS_DURATION_TAG = "maxDurationInTicks";
    public static final String IS_FRESHLY_INSERTED = "isFreshly";

    public ItemInTubeWrapper(ItemStack stack, Queue<Direction> moves, int ticksToTravel) {
        this.stack = stack.m_41777_();
        this.remainingMoves = new LinkedList();
        for (Direction dir : moves) {
            this.remainingMoves.add(dir);
        }
        this.ticksElapsed = 0;
        this.maximumDurationInTube = ticksToTravel;
    }

    public ItemInTubeWrapper(ItemStack stack, Queue<Direction> moves, int ticksToTravel, Direction firstMove) {
        this(stack, moves, ticksToTravel);
        if (firstMove != null) {
            this.remainingMoves.addFirst(firstMove);
            this.freshlyInserted = true;
        }
    }

    public static ItemInTubeWrapper readFromNBT(CompoundTag compound, OctahedralGroup group) {
        ItemStack stack = ItemStack.m_41712_((CompoundTag)compound);
        int[] moveBuffer = compound.m_128465_(MOVES_REMAINING_TAG);
        int ticksElapsed = compound.m_128451_(TICKS_REMAINING_TAG);
        int maxDuration = compound.m_128451_(TICKS_DURATION_TAG);
        boolean isFreshlyInserted = compound.m_128471_(IS_FRESHLY_INSERTED);
        ItemInTubeWrapper wrapper = new ItemInTubeWrapper(stack, ItemInTubeWrapper.decompressMoveList(moveBuffer, group), maxDuration);
        wrapper.ticksElapsed = ticksElapsed;
        wrapper.freshlyInserted = isFreshlyInserted;
        return wrapper;
    }

    public CompoundTag writeToNBT(CompoundTag compound, OctahedralGroup group) {
        compound.m_128365_(MOVES_REMAINING_TAG, (Tag)ItemInTubeWrapper.compressMoveList(this.remainingMoves, group));
        compound.m_128405_(TICKS_REMAINING_TAG, this.ticksElapsed);
        compound.m_128405_(TICKS_DURATION_TAG, this.maximumDurationInTube);
        compound.m_128379_(IS_FRESHLY_INSERTED, this.freshlyInserted);
        this.stack.m_41739_(compound);
        return compound;
    }

    public static IntArrayTag compressMoveList(Queue<Direction> moves, OctahedralGroup group) {
        if (moves == null || moves.isEmpty()) {
            return new IntArrayTag(new int[0]);
        }
        OctahedralGroup normalizer = group.m_174944_();
        int moveIndex = 0;
        ArrayList<Integer> buffer = new ArrayList<Integer>();
        Direction currentMove = moves.peek();
        buffer.add(normalizer.m_56528_(currentMove).ordinal());
        buffer.add(0);
        for (Direction dir : moves) {
            if (!dir.equals((Object)currentMove)) {
                buffer.add(normalizer.m_56528_(dir).ordinal());
                buffer.add(1);
                currentMove = dir;
                moveIndex += 2;
                continue;
            }
            buffer.set(moveIndex + 1, (Integer)buffer.get(moveIndex + 1) + 1);
        }
        IntArrayTag nbt = new IntArrayTag(buffer);
        return nbt;
    }

    public static Queue<Direction> decompressMoveList(int[] buffer, OctahedralGroup group) {
        LinkedList<Direction> moves = new LinkedList<Direction>();
        int size = buffer.length;
        if (size % 2 != 0) {
            return moves;
        }
        int pairCount = size / 2;
        for (int i = 0; i < pairCount; ++i) {
            Direction dir = group.m_56528_(Direction.m_122376_((int)buffer[i * 2]));
            int moveCount = buffer[i * 2 + 1];
            for (int count = 0; count < moveCount; ++count) {
                moves.add(dir);
            }
        }
        return moves;
    }
}

