/*
 * Decompiled with CFR 0.152.
 */
package commoble.tubesreloaded.blocks.tube;

import commoble.tubesreloaded.blocks.tube.RemoteConnection;
import commoble.tubesreloaded.util.NestedBoundingBox;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RaytraceHelper {
    public static Vec3[] getInterpolatedDifferences(Vec3 vector) {
        int points = 17;
        Vec3[] list = new Vec3[points];
        double dx = vector.m_7096_();
        double dy = vector.m_7098_();
        double dz = vector.m_7094_();
        for (int point = 0; point < points; ++point) {
            double startLerp = RaytraceHelper.getFractionalLerp(point, points - 1);
            list[point] = new Vec3(startLerp * dx, startLerp * dy, startLerp * dz);
        }
        return list;
    }

    public static Vec3[] getInterpolatedPoints(Vec3 lower, Vec3 upper) {
        Vec3 diff = upper.m_82546_(lower);
        Vec3[] diffs = RaytraceHelper.getInterpolatedDifferences(diff);
        Vec3[] points = new Vec3[diffs.length];
        for (int i = 0; i < points.length; ++i) {
            points[i] = lower.m_82549_(diffs[i]);
        }
        return points;
    }

    @Nullable
    public static Vec3 doesBlockStateIntersectTubeConnections(BlockPos tubePos, BlockPos placePos, BlockGetter raytraceWorld, @Nonnull BlockState placeState, Set<BlockPos> checkedTubePositions, Map<Direction, RemoteConnection> connections) {
        for (Map.Entry<Direction, RemoteConnection> entry : connections.entrySet()) {
            Direction toSide;
            Direction fromSide;
            Vec3 hit;
            RemoteConnection connection = entry.getValue();
            BlockPos pos = connection.toPos;
            if (checkedTubePositions.contains(pos) || (hit = RaytraceHelper.doesBlockStateIntersectConnection(tubePos, fromSide = entry.getKey(), pos, toSide = connection.toSide, placePos, placeState, connection.getBox(), raytraceWorld)) == null) continue;
            return hit;
        }
        return null;
    }

    @Nullable
    public static Vec3 doesBlockStateIntersectConnection(BlockPos startPos, Direction startSide, BlockPos endPos, Direction endSide, BlockPos placePos, @Nonnull BlockState placeState, NestedBoundingBox box, BlockGetter world) {
        VoxelShape shape = placeState.m_60812_(world, placePos);
        for (AABB aabb : shape.m_83299_()) {
            if (!box.intersects(aabb.m_82338_(placePos))) continue;
            Vec3 startVec = RaytraceHelper.getTubeSideCenter(startPos, startSide);
            Vec3 endVec = RaytraceHelper.getTubeSideCenter(endPos, endSide);
            return RaytraceHelper.getTubeRaytraceHit(startVec, endVec, world);
        }
        return null;
    }

    public static double getFractionalLerp(int current, int max) {
        return (double)current / (double)max;
    }

    public static Vec3 getTubeSideCenter(BlockPos pos, Direction side) {
        Vec3 center = Vec3.m_82512_((Vec3i)pos);
        double offsetFromCenter = 0.25;
        double xOff = (double)side.m_122429_() * offsetFromCenter;
        double yOff = (double)side.m_122430_() * offsetFromCenter;
        double zOff = (double)side.m_122431_() * offsetFromCenter;
        return center.m_82520_(xOff, yOff, zOff);
    }

    @Nullable
    public static Vec3 getTubeRaytraceHit(Vec3 startVec, Vec3 endVec, BlockGetter world) {
        Vec3[] points = RaytraceHelper.getInterpolatedPoints(startVec, endVec);
        int pointCount = points.length;
        int rayTraceCount = pointCount - 1;
        for (int i = 0; i < rayTraceCount; ++i) {
            ClipContext context = new ClipContext(points[i], points[i + 1], ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, null);
            BlockHitResult result = RaytraceHelper.rayTraceBlocks(world, context);
            if (result.m_6662_() == HitResult.Type.MISS) continue;
            return result.m_82450_();
        }
        return null;
    }

    public static BlockHitResult rayTraceBlocks(BlockGetter world, ClipContext context) {
        return RaytraceHelper.doRayTrace(context, (rayTraceContext, pos) -> {
            BlockState state = world.m_8055_(pos);
            Vec3 startVec = rayTraceContext.m_45702_();
            Vec3 endVec = rayTraceContext.m_45693_();
            VoxelShape shape = rayTraceContext.m_45694_(state, world, pos);
            BlockHitResult result = world.m_45558_(startVec, endVec, pos, shape, state);
            return result;
        }, rayTraceContext -> {
            Vec3 difference = rayTraceContext.m_45702_().m_82546_(rayTraceContext.m_45693_());
            return BlockHitResult.m_82426_((Vec3)rayTraceContext.m_45693_(), (Direction)Direction.m_122366_((double)difference.f_82479_, (double)difference.f_82480_, (double)difference.f_82481_), (BlockPos)new BlockPos(rayTraceContext.m_45693_()));
        });
    }

    static <T> T doRayTrace(ClipContext context, BiFunction<ClipContext, BlockPos, T> rayTracer, Function<ClipContext, T> missFactory) {
        int startZInt;
        int startYInt;
        Vec3 end;
        Vec3 start = context.m_45702_();
        if (start.equals((Object)(end = context.m_45693_()))) {
            return missFactory.apply(context);
        }
        double endX = Mth.m_14139_((double)-1.0E-7, (double)end.f_82479_, (double)start.f_82479_);
        double endY = Mth.m_14139_((double)-1.0E-7, (double)end.f_82480_, (double)start.f_82480_);
        double endZ = Mth.m_14139_((double)-1.0E-7, (double)end.f_82481_, (double)start.f_82481_);
        double startX = Mth.m_14139_((double)-1.0E-7, (double)start.f_82479_, (double)end.f_82479_);
        double startY = Mth.m_14139_((double)-1.0E-7, (double)start.f_82480_, (double)end.f_82480_);
        double startZ = Mth.m_14139_((double)-1.0E-7, (double)start.f_82481_, (double)end.f_82481_);
        int startXInt = Mth.m_14107_((double)startX);
        BlockPos.MutableBlockPos mutaPos = new BlockPos.MutableBlockPos(startXInt, startYInt = Mth.m_14107_((double)startY), startZInt = Mth.m_14107_((double)startZ));
        T result = rayTracer.apply(context, (BlockPos)mutaPos);
        if (result != null) {
            return result;
        }
        double dx = endX - startX;
        double dy = endY - startY;
        double dz = endZ - startZ;
        int xSign = Mth.m_14205_((double)dx);
        int ySign = Mth.m_14205_((double)dy);
        int zSign = Mth.m_14205_((double)dz);
        double reciprocalX = xSign == 0 ? Double.MAX_VALUE : (double)xSign / dx;
        double reciprocalY = ySign == 0 ? Double.MAX_VALUE : (double)ySign / dy;
        double reciprocalZ = zSign == 0 ? Double.MAX_VALUE : (double)zSign / dz;
        double calcX = reciprocalX * (xSign > 0 ? 1.0 - Mth.m_14185_((double)startX) : Mth.m_14185_((double)startX));
        double calcY = reciprocalY * (ySign > 0 ? 1.0 - Mth.m_14185_((double)startY) : Mth.m_14185_((double)startY));
        double calcZ = reciprocalZ * (zSign > 0 ? 1.0 - Mth.m_14185_((double)startZ) : Mth.m_14185_((double)startZ));
        while (calcX <= 1.0 || calcY <= 1.0 || calcZ <= 1.0) {
            T fallbackResult;
            if (calcX < calcY) {
                if (calcX < calcZ) {
                    startXInt += xSign;
                    calcX += reciprocalX;
                } else {
                    startZInt += zSign;
                    calcZ += reciprocalZ;
                }
            } else if (calcY < calcZ) {
                startYInt += ySign;
                calcY += reciprocalY;
            } else {
                startZInt += zSign;
                calcZ += reciprocalZ;
            }
            if ((fallbackResult = rayTracer.apply(context, (BlockPos)mutaPos.m_122178_(startXInt, startYInt, startZInt))) == null) continue;
            return fallbackResult;
        }
        return missFactory.apply(context);
    }
}

