/*
 * Decompiled with CFR 0.152.
 */
package commoble.tubesreloaded.blocks.tube;

import com.mojang.math.OctahedralGroup;
import commoble.tubesreloaded.blocks.tube.RaytraceHelper;
import commoble.tubesreloaded.util.NestedBoundingBox;
import commoble.tubesreloaded.util.PosHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RemoteConnection {
    public final Direction toSide;
    public final BlockPos toPos;
    public final boolean isPrimary;
    private final BlockPos fromPos;
    private NestedBoundingBox box;

    public RemoteConnection(Direction fromSide, Direction toSide, BlockPos fromPos, BlockPos toPos, boolean isPrimary) {
        this.toSide = toSide;
        this.toPos = toPos;
        this.isPrimary = isPrimary;
        this.fromPos = fromPos;
    }

    public NestedBoundingBox getBox() {
        if (this.box == null) {
            this.box = RemoteConnection.getNestedBoundingBoxForConnectedPos(this.fromPos, this.toPos);
        }
        return this.box;
    }

    public Storage toStorage(BlockPos tubePos) {
        return new Storage(this.toSide, this.toPos.m_121996_((Vec3i)tubePos), this.isPrimary);
    }

    public static RemoteConnection fromStorage(Storage storage, Direction fromSide, BlockPos fromPos) {
        return new RemoteConnection(fromSide, storage.toSide, fromPos, storage.toPos.m_121955_((Vec3i)fromPos), storage.isPrimary);
    }

    private static NestedBoundingBox getNestedBoundingBoxForConnectedPos(BlockPos from, BlockPos to) {
        Vec3 thisVec = Vec3.m_82512_((Vec3i)from);
        Vec3 otherVec = Vec3.m_82512_((Vec3i)to);
        boolean otherHigher = otherVec.f_82480_ > thisVec.f_82480_;
        Vec3 higherVec = otherHigher ? otherVec : thisVec;
        Vec3 lowerVec = otherHigher ? thisVec : otherVec;
        Vec3[] points = RaytraceHelper.getInterpolatedPoints(lowerVec, higherVec);
        int segmentCount = points.length - 1;
        AABB[] boxes = new AABB[segmentCount];
        for (int i = 0; i < segmentCount; ++i) {
            boxes[i] = new AABB(points[i], points[i + 1]);
        }
        return NestedBoundingBox.fromAABBs(boxes);
    }

    public static class Storage {
        public final Direction toSide;
        public final BlockPos toPos;
        public final boolean isPrimary;

        public Storage(Direction toSide, BlockPos toPos, boolean isPrimary) {
            this.toSide = toSide;
            this.toPos = toPos;
            this.isPrimary = isPrimary;
        }

        public static Storage fromNBT(CompoundTag nbt, OctahedralGroup group) {
            Direction toSide = group.m_56528_(Direction.m_122402_((String)nbt.m_128461_("toSide")));
            BlockPos toPos = PosHelper.transform(NbtUtils.m_129239_((CompoundTag)nbt.m_128469_("toPos")), group);
            boolean isPrimary = nbt.m_128471_("isPrimary");
            return new Storage(toSide, toPos, isPrimary);
        }

        public CompoundTag toNBT(OctahedralGroup group) {
            OctahedralGroup normalizer = group.m_174944_();
            CompoundTag nbt = new CompoundTag();
            nbt.m_128359_("toSide", normalizer.m_56528_(this.toSide).m_122433_());
            nbt.m_128365_("toPos", (Tag)NbtUtils.m_129224_((BlockPos)PosHelper.transform(this.toPos, normalizer)));
            nbt.m_128379_("isPrimary", this.isPrimary);
            return nbt;
        }
    }
}

