/*
 * Decompiled with CFR 0.152.
 */
package commoble.tubesreloaded.blocks.tube;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import commoble.tubesreloaded.ClientProxy;
import commoble.tubesreloaded.MiscCodecs;
import commoble.tubesreloaded.blocks.tube.TubesInChunk;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.ChunkPos;
import net.minecraftforge.network.NetworkEvent;

public class SyncTubesInChunkPacket {
    public static final Codec<SyncTubesInChunkPacket> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)MiscCodecs.COMPRESSED_CHUNK_POS.fieldOf("chunk").forGetter(SyncTubesInChunkPacket::getChunkPos), (App)TubesInChunk.FIELD_CODEC.forGetter(SyncTubesInChunkPacket::getTubesInChunk)).apply((Applicative)instance, SyncTubesInChunkPacket::new));
    public static final SyncTubesInChunkPacket BAD_PACKET = new SyncTubesInChunkPacket(new ChunkPos(ChunkPos.f_45577_), (Set<BlockPos>)ImmutableSet.of());
    private final ChunkPos chunkPos;
    private final Set<BlockPos> tubesInChunk;

    public ChunkPos getChunkPos() {
        return this.chunkPos;
    }

    public Set<BlockPos> getTubesInChunk() {
        return this.tubesInChunk;
    }

    public SyncTubesInChunkPacket(ChunkPos chunkPos, Set<BlockPos> tubesInChunk) {
        this.chunkPos = chunkPos;
        this.tubesInChunk = tubesInChunk;
    }

    public void write(FriendlyByteBuf buffer) {
        buffer.m_130079_(CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this).result().orElse(new CompoundTag()));
    }

    public static SyncTubesInChunkPacket read(FriendlyByteBuf buffer) {
        return CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)buffer.m_130260_()).result().map(Pair::getFirst).orElse(BAD_PACKET);
    }

    public void handle(Supplier<NetworkEvent.Context> contextGetter) {
        NetworkEvent.Context context = contextGetter.get();
        contextGetter.get().enqueueWork(() -> ClientProxy.updateTubesInChunk(this.chunkPos, this.tubesInChunk));
        context.setPacketHandled(true);
    }
}

