/*
 * Decompiled with CFR 0.152.
 */
package commoble.tubesreloaded.blocks.tube;

import com.google.common.collect.ImmutableList;
import com.mojang.math.OctahedralGroup;
import commoble.tubesreloaded.TubesReloaded;
import commoble.tubesreloaded.blocks.extractor.ExtractorBlock;
import commoble.tubesreloaded.blocks.filter.FilterBlock;
import commoble.tubesreloaded.blocks.loader.LoaderBlock;
import commoble.tubesreloaded.blocks.tube.RemoteConnection;
import commoble.tubesreloaded.blocks.tube.TubeBlockEntity;
import commoble.tubesreloaded.blocks.tube.TubesInChunk;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.items.CapabilityItemHandler;

public class TubeBlock
extends Block
implements SimpleWaterloggedBlock,
EntityBlock {
    public static final Direction[] FACING_VALUES = Direction.values();
    public static final BooleanProperty DOWN = PipeBlock.f_55153_;
    public static final BooleanProperty UP = PipeBlock.f_55152_;
    public static final BooleanProperty NORTH = PipeBlock.f_55148_;
    public static final BooleanProperty SOUTH = PipeBlock.f_55150_;
    public static final BooleanProperty WEST = PipeBlock.f_55151_;
    public static final BooleanProperty EAST = PipeBlock.f_55149_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    public static final OctahedralGroup[] TUBE_GROUPS = new OctahedralGroup[]{OctahedralGroup.IDENTITY, OctahedralGroup.ROT_180_FACE_XZ, OctahedralGroup.ROT_90_Y_NEG, OctahedralGroup.ROT_90_Y_POS, OctahedralGroup.INVERT_X, OctahedralGroup.INVERT_Z, OctahedralGroup.SWAP_XZ, OctahedralGroup.SWAP_NEG_XZ};
    public static final EnumProperty<OctahedralGroup> GROUP = EnumProperty.m_61598_((String)"group", OctahedralGroup.class, (Enum[])TUBE_GROUPS);
    public static final VoxelShape[] SHAPES = TubeBlock.makeShapes();
    private static final BooleanProperty[] DIRECTION_PROPERTIES = new BooleanProperty[]{DOWN, UP, NORTH, SOUTH, WEST, EAST};
    public final ResourceLocation textureLocation;

    public static BooleanProperty getPropertyForDirection(Direction dir) {
        return DIRECTION_PROPERTIES[dir.ordinal()];
    }

    public TubeBlock(ResourceLocation textureLocation, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(false))).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).m_61124_(GROUP, (Comparable)OctahedralGroup.IDENTITY));
        this.textureLocation = textureLocation;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{DOWN, UP, NORTH, SOUTH, WEST, EAST, WATERLOGGED, GROUP});
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    @Deprecated
    public void m_6807_(BlockState newState, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        this.updateTubeSet(level, pos, Set::add);
        super.m_6807_(newState, level, pos, oldState, isMoving);
    }

    @Deprecated
    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean isMoving) {
        this.updateTubeSet(level, pos, Set::remove);
        BlockEntity te = level.m_7702_(pos);
        if (te instanceof TubeBlockEntity) {
            TubeBlockEntity tube = (TubeBlockEntity)te;
            if (!state.m_60713_(newState.m_60734_())) {
                tube.dropItems();
                tube.clearRemoteConnections();
            }
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    public void updateTubeSet(Level level, BlockPos pos, BiConsumer<Set<BlockPos>, BlockPos> consumer) {
        LevelChunk chunk = level.m_46745_(pos);
        if (chunk != null) {
            chunk.getCapability(TubesInChunk.CAPABILITY).ifPresent(tubes -> {
                Set<BlockPos> set = tubes.getPositions();
                consumer.accept(set, pos);
                tubes.setPositions(set);
            });
        }
    }

    @Deprecated
    public void m_6861_(BlockState state, Level level, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        BlockEntity blockEntity;
        if (!level.f_46443_ && (blockEntity = level.m_7702_(pos)) instanceof TubeBlockEntity) {
            TubeBlockEntity tube = (TubeBlockEntity)blockEntity;
            tube.onPossibleNetworkUpdateRequired();
        }
        super.m_6861_(state, level, pos, blockIn, fromPos, isMoving);
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity blockEntity;
        if (!world.f_46443_ && (blockEntity = world.m_7702_(pos)) instanceof TubeBlockEntity) {
            TubeBlockEntity te = (TubeBlockEntity)blockEntity;
            te.onPossibleNetworkUpdateRequired();
        }
        super.m_6402_(world, pos, state, placer, stack);
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        FluidState fluidstate = world.m_6425_(pos);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)super.m_5573_(context).m_61124_((Property)DOWN, (Comparable)Boolean.valueOf(this.canConnectTo((BlockGetter)world, pos, Direction.DOWN)))).m_61124_((Property)UP, (Comparable)Boolean.valueOf(this.canConnectTo((BlockGetter)world, pos, Direction.UP)))).m_61124_((Property)NORTH, (Comparable)Boolean.valueOf(this.canConnectTo((BlockGetter)world, pos, Direction.NORTH)))).m_61124_((Property)SOUTH, (Comparable)Boolean.valueOf(this.canConnectTo((BlockGetter)world, pos, Direction.SOUTH)))).m_61124_((Property)WEST, (Comparable)Boolean.valueOf(this.canConnectTo((BlockGetter)world, pos, Direction.WEST)))).m_61124_((Property)EAST, (Comparable)Boolean.valueOf(this.canConnectTo((BlockGetter)world, pos, Direction.EAST)))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(fluidstate.m_76152_() == Fluids.f_76193_));
    }

    protected boolean canConnectTo(BlockGetter level, BlockPos pos, Direction face) {
        BlockPos newPos = pos.m_121945_(face);
        BlockState state = level.m_8055_(newPos);
        Block newBlock = state.m_60734_();
        BlockEntity blockEntity = level.m_7702_(newPos);
        if (newBlock instanceof TubeBlock) {
            TubeBlock tube = (TubeBlock)newBlock;
            if (blockEntity instanceof TubeBlockEntity) {
                TubeBlockEntity tubeEntity = (TubeBlockEntity)blockEntity;
                return this.isTubeCompatible(tube) && !tubeEntity.hasRemoteConnection(face.m_122424_());
            }
        }
        if (newBlock instanceof LoaderBlock && ((Direction)state.m_61143_((Property)LoaderBlock.FACING)).equals((Object)face.m_122424_())) {
            return true;
        }
        if (newBlock instanceof ExtractorBlock && ((Direction)state.m_61143_((Property)ExtractorBlock.FACING)).equals((Object)face.m_122424_())) {
            return true;
        }
        if (newBlock instanceof FilterBlock && ((Direction)state.m_61143_((Property)FilterBlock.FACING)).equals((Object)face.m_122424_())) {
            return true;
        }
        if (blockEntity == null) {
            return false;
        }
        return blockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face.m_122424_()).isPresent();
    }

    public boolean isTubeCompatible(TubeBlock tube) {
        return true;
    }

    public static boolean hasOpenConnection(Level level, BlockPos pos, BlockState state, Direction face) {
        Block block = state.m_60734_();
        if (block instanceof TubeBlock) {
            TubeBlockEntity tube;
            BlockEntity blockEntity;
            TubeBlock tubeBlock = (TubeBlock)block;
            return !tubeBlock.hasConnectionOnSide(state, face) && (blockEntity = level.m_7702_(pos)) instanceof TubeBlockEntity && !(tube = (TubeBlockEntity)blockEntity).hasRemoteConnection(face);
        }
        return false;
    }

    public static Set<Direction> getConnectedDirections(BlockState state) {
        Block block = state.m_60734_();
        HashSet<Direction> dirs = new HashSet<Direction>();
        if (block instanceof TubeBlock) {
            TubeBlock tubeBlock = (TubeBlock)block;
            for (Direction dir : Direction.values()) {
                if (!tubeBlock.hasConnectionOnSide(state, dir)) continue;
                dirs.add(dir);
            }
        }
        return dirs;
    }

    public static Collection<RemoteConnection> getRemoteConnections(Level level, BlockPos pos) {
        Object object;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof TubeBlockEntity) {
            TubeBlockEntity tube = (TubeBlockEntity)blockEntity;
            object = tube.getRemoteConnections().values();
        } else {
            object = ImmutableList.of();
        }
        return object;
    }

    public BlockState m_7417_(BlockState stateIn, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        if (((Boolean)stateIn.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return (BlockState)stateIn.m_61124_((Property)PipeBlock.f_55154_.get(facing), (Comparable)Boolean.valueOf(this.canConnectTo((BlockGetter)level, currentPos, facing)));
    }

    public static VoxelShape[] makeShapes() {
        double MIN_VOXEL = 0.0;
        double ONE_QUARTER = 4.0;
        double THREE_QUARTERS = 12.0;
        double SIX_SIXTEENTHS = 6.0;
        double TEN_SIXTEENTHS = 10.0;
        double MAX_VOXEL = 16.0;
        VoxelShape[] shapes = new VoxelShape[64];
        VoxelShape core = Block.m_49796_((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);
        VoxelShape down = Block.m_49796_((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)12.0, (double)10.0);
        VoxelShape up = Block.m_49796_((double)6.0, (double)12.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);
        VoxelShape north = Block.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)10.0, (double)10.0, (double)4.0);
        VoxelShape south = Block.m_49796_((double)6.0, (double)6.0, (double)12.0, (double)10.0, (double)10.0, (double)16.0);
        VoxelShape west = Block.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)12.0, (double)10.0, (double)10.0);
        VoxelShape east = Block.m_49796_((double)12.0, (double)6.0, (double)6.0, (double)16.0, (double)10.0, (double)10.0);
        VoxelShape[] dunswe = new VoxelShape[]{down, up, north, south, west, east};
        for (int i = 0; i < 64; ++i) {
            shapes[i] = core;
            for (int j = 0; j < 6; ++j) {
                if ((i & 1 << j) == 0) continue;
                shapes[i] = Shapes.m_83110_((VoxelShape)shapes[i], (VoxelShape)dunswe[j]);
            }
        }
        return shapes;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPES[this.getShapeIndex(state)];
    }

    public boolean hasConnectionOnSide(BlockState tubeState, Direction side) {
        return (Boolean)tubeState.m_61143_((Property)PipeBlock.f_55154_.get(side));
    }

    public int getShapeIndex(BlockState state) {
        int index = 0;
        for (int j = 0; j < FACING_VALUES.length; ++j) {
            if (!this.hasConnectionOnSide(state, FACING_VALUES[j])) continue;
            index |= 1 << j;
        }
        return index;
    }

    @Deprecated
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return ((BlockEntityType)TubesReloaded.get().tubeEntity.get()).m_155264_(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return type == TubesReloaded.get().tubeEntity.get() ? TubeBlockEntity.TICKER : super.m_142354_(level, state, type);
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        BooleanProperty prop;
        Direction dir;
        int i;
        BlockState newState = state;
        EnumSet<Direction> newDirections = EnumSet.noneOf(Direction.class);
        for (i = 0; i < 4; ++i) {
            dir = Direction.m_122407_((int)i);
            prop = TubeBlock.getPropertyForDirection(dir);
            Direction rotatedDir = rotation.m_55954_(dir);
            if (!((Boolean)state.m_61143_((Property)prop)).booleanValue()) continue;
            newDirections.add(rotatedDir);
        }
        for (i = 0; i < 4; ++i) {
            dir = Direction.m_122407_((int)i);
            prop = TubeBlock.getPropertyForDirection(dir);
            newState = (BlockState)newState.m_61124_((Property)prop, (Comparable)Boolean.valueOf(newDirections.contains(dir)));
        }
        return (BlockState)newState.m_61124_(GROUP, (Comparable)rotation.m_55948_().m_56521_((OctahedralGroup)state.m_61143_(GROUP)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        BooleanProperty prop;
        Direction dir;
        int i;
        BlockState newState = state;
        EnumSet<Direction> newDirections = EnumSet.noneOf(Direction.class);
        for (i = 0; i < 4; ++i) {
            dir = Direction.m_122407_((int)i);
            prop = TubeBlock.getPropertyForDirection(dir);
            Direction mirroredDir = mirror.m_54848_(dir);
            if (!((Boolean)state.m_61143_((Property)prop)).booleanValue()) continue;
            newDirections.add(mirroredDir);
        }
        for (i = 0; i < 4; ++i) {
            dir = Direction.m_122407_((int)i);
            prop = TubeBlock.getPropertyForDirection(dir);
            newState = (BlockState)newState.m_61124_((Property)prop, (Comparable)Boolean.valueOf(newDirections.contains(dir)));
        }
        return (BlockState)newState.m_61124_(GROUP, (Comparable)mirror.m_54842_().m_56521_((OctahedralGroup)state.m_61143_(GROUP)));
    }
}

