/*
 * Decompiled with CFR 0.152.
 */
package commoble.tubesreloaded.blocks.tube;

import com.mojang.math.OctahedralGroup;
import commoble.tubesreloaded.TubesReloaded;
import commoble.tubesreloaded.blocks.tube.ItemInTubeWrapper;
import commoble.tubesreloaded.blocks.tube.RemoteConnection;
import commoble.tubesreloaded.blocks.tube.TubeBlock;
import commoble.tubesreloaded.blocks.tube.TubeBreakPacket;
import commoble.tubesreloaded.blocks.tube.TubeInventoryHandler;
import commoble.tubesreloaded.routing.Route;
import commoble.tubesreloaded.routing.RoutingNetwork;
import commoble.tubesreloaded.util.WorldHelper;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Containers;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.network.PacketDistributor;

public class TubeBlockEntity
extends BlockEntity {
    public static final String INV_NBT_KEY_ADD = "inventory_new_items";
    public static final String INV_NBT_KEY_RESET = "inventory_reset";
    public static final String CONNECTIONS = "connections";
    public static final AABB EMPTY_AABB = new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    public static final String SIDE = "side";
    public static final BlockEntityTicker<TubeBlockEntity> TICKER = (level, pos, state, tube) -> tube.tick();
    private Map<Direction, RemoteConnection> remoteConnections = new HashMap<Direction, RemoteConnection>();
    private boolean isConnectionSyncDirty = false;
    private AABB renderAABB = EMPTY_AABB;
    @Nonnull
    public Queue<ItemInTubeWrapper> inventory = new LinkedList<ItemInTubeWrapper>();
    protected final TubeInventoryHandler[] inventoryHandlers = (TubeInventoryHandler[])Arrays.stream(Direction.values()).map(dir -> new TubeInventoryHandler(this, (Direction)dir)).toArray(TubeInventoryHandler[]::new);
    protected final LazyOptional<IItemHandler>[] handlerOptionals = (LazyOptional[])Arrays.stream(this.inventoryHandlers).map(handler -> LazyOptional.of(() -> handler)).toArray(LazyOptional[]::new);
    private Queue<ItemInTubeWrapper> wrappersToSendToClient = new LinkedList<ItemInTubeWrapper>();
    public Queue<ItemInTubeWrapper> incomingWrapperBuffer = new LinkedList<ItemInTubeWrapper>();
    @Nonnull
    private RoutingNetwork network = RoutingNetwork.INVALID_NETWORK;

    public TubeBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public TubeBlockEntity(BlockPos pos, BlockState state) {
        this((BlockEntityType)TubesReloaded.get().tubeEntity.get(), pos, state);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean addConnection(LevelAccessor level, Direction sideA, BlockPos posA, Direction sideB, BlockPos posB) {
        BlockEntity blockEntity = level.m_7702_(posA);
        if (!(blockEntity instanceof TubeBlockEntity)) return false;
        TubeBlockEntity tubeA = (TubeBlockEntity)blockEntity;
        blockEntity = level.m_7702_(posB);
        if (!(blockEntity instanceof TubeBlockEntity)) return false;
        TubeBlockEntity tubeB = (TubeBlockEntity)blockEntity;
        boolean bl = TubeBlockEntity.addConnection(level, tubeA, sideA, tubeB, sideB);
        return bl;
    }

    public static boolean addConnection(LevelAccessor level, @Nonnull TubeBlockEntity fromTube, @Nonnull Direction fromSide, @Nonnull TubeBlockEntity toTube, @Nonnull Direction toSide) {
        fromTube.addConnection(fromSide, toSide, toTube.f_58858_, true);
        toTube.addConnection(toSide, fromSide, fromTube.f_58858_, false);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean areTubesConnected(LevelAccessor level, BlockPos posA, BlockPos posB) {
        BlockEntity blockEntity = level.m_7702_(posA);
        if (!(blockEntity instanceof TubeBlockEntity)) return false;
        TubeBlockEntity tubeA = (TubeBlockEntity)blockEntity;
        blockEntity = level.m_7702_(posB);
        if (!(blockEntity instanceof TubeBlockEntity)) return false;
        TubeBlockEntity tubeB = (TubeBlockEntity)blockEntity;
        if (!tubeA.hasRemoteConnection(posB)) return false;
        if (!tubeB.hasRemoteConnection(posA)) return false;
        return true;
    }

    public static void removeConnection(LevelAccessor level, BlockPos posA, BlockPos posB) {
        BlockEntity blockEntity = level.m_7702_(posA);
        if (blockEntity instanceof TubeBlockEntity) {
            TubeBlockEntity tubeA = (TubeBlockEntity)blockEntity;
            tubeA.removeConnection(posB);
        }
        if ((blockEntity = level.m_7702_(posB)) instanceof TubeBlockEntity) {
            TubeBlockEntity tubeB = (TubeBlockEntity)blockEntity;
            tubeB.removeConnection(posA);
        }
    }

    public static AABB getAABBContainingConnectedPositions(BlockPos startPos, Set<BlockPos> remoteConnections) {
        AABB aabb = new AABB(startPos);
        for (BlockPos pos : remoteConnections) {
            aabb = aabb.m_82367_(new AABB(pos));
        }
        aabb = aabb.m_82367_(new AABB(startPos.m_7918_(-1, -1, -1)));
        aabb = aabb.m_82367_(new AABB(startPos.m_7918_(1, 1, 1)));
        return aabb;
    }

    public RoutingNetwork getNetwork() {
        if (this.network.invalid) {
            this.network = RoutingNetwork.buildNetworkFrom(this.f_58858_, this.f_58857_);
        }
        return this.network;
    }

    public void setNetwork(RoutingNetwork network) {
        this.network = network;
    }

    public boolean isTubeCompatible(TubeBlockEntity tube) {
        Block thisBlock = this.m_58900_().m_60734_();
        Block otherBlock = tube.m_58900_().m_60734_();
        if (thisBlock instanceof TubeBlock && otherBlock instanceof TubeBlock) {
            return ((TubeBlock)thisBlock).isTubeCompatible((TubeBlock)otherBlock);
        }
        return false;
    }

    public Set<Direction> getAdjacentConnectedDirections() {
        BlockState state = this.m_58900_();
        return TubeBlock.getConnectedDirections(state);
    }

    public Set<Direction> getAllConnectedDirections() {
        HashSet<Direction> result = new HashSet<Direction>();
        result.addAll(this.getAdjacentConnectedDirections());
        result.addAll(this.getRemoteConnections().keySet());
        return result;
    }

    public Route getBestRoute(Direction insertionSide, ItemStack stack) {
        return this.getNetwork().getBestRoute(this.f_58857_, this.f_58858_, insertionSide, stack);
    }

    public Map<Direction, RemoteConnection> getRemoteConnections() {
        return this.remoteConnections;
    }

    public boolean hasRemoteConnection(BlockPos otherPos) {
        return this.getDirectionOfRemoteConnection(otherPos) != null;
    }

    @Nullable
    public RemoteConnection getRemoteConnection(Direction face) {
        return this.getRemoteConnections().get(face);
    }

    public boolean hasRemoteConnection(Direction face) {
        return this.getRemoteConnections().containsKey(face);
    }

    @Nullable
    public Direction getDirectionOfRemoteConnection(BlockPos otherPos) {
        for (Map.Entry<Direction, RemoteConnection> entry : this.remoteConnections.entrySet()) {
            if (!entry.getValue().toPos.equals((Object)otherPos)) continue;
            return entry.getKey();
        }
        return null;
    }

    public void clearRemoteConnections() {
        if (!this.remoteConnections.isEmpty()) {
            for (Map.Entry<Direction, RemoteConnection> entry : this.remoteConnections.entrySet()) {
                BlockEntity blockEntity = this.f_58857_.m_7702_(entry.getValue().toPos);
                if (!(blockEntity instanceof TubeBlockEntity)) continue;
                TubeBlockEntity otherTube = (TubeBlockEntity)blockEntity;
                otherTube.removeConnection(this.f_58858_);
            }
            this.remoteConnections = new HashMap<Direction, RemoteConnection>();
            this.setConnectionSyncDirty(true);
            this.onDataUpdated();
        }
    }

    private void addConnection(Direction thisSide, Direction otherSide, BlockPos otherPos, boolean isPrimary) {
        this.remoteConnections.put(thisSide, new RemoteConnection(thisSide, otherSide, this.f_58858_, otherPos, isPrimary));
        this.network.invalid = true;
        this.setConnectionSyncDirty(true);
        this.onDataUpdated();
    }

    private void removeConnection(BlockPos otherPos) {
        BlockState newState = this.m_58900_();
        for (Direction dir : Direction.values()) {
            RemoteConnection connection = this.remoteConnections.get(dir);
            if (connection == null || !connection.toPos.equals((Object)otherPos)) continue;
            this.remoteConnections.remove(dir);
            this.setConnectionSyncDirty(true);
        }
        if (!this.f_58857_.f_46443_) {
            this.onPossibleNetworkUpdateRequired();
            this.network.invalid = true;
            this.f_58857_.m_46597_(this.f_58858_, newState);
            TubesReloaded.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(() -> this.f_58857_.m_46745_(this.f_58858_)), (Object)new TubeBreakPacket(Vec3.m_82512_((Vec3i)this.f_58858_), Vec3.m_82512_((Vec3i)otherPos)));
        }
        this.onDataUpdated();
    }

    public AABB getRenderBoundingBox() {
        return this.renderAABB;
    }

    public boolean isConnectionSyncDirty() {
        return this.isConnectionSyncDirty;
    }

    public void setConnectionSyncDirty(boolean dirty) {
        this.isConnectionSyncDirty = dirty;
    }

    public void invalidateCaps() {
        for (LazyOptional<IItemHandler> handlerOptional : this.handlerOptionals) {
            handlerOptional.invalidate();
        }
        super.invalidateCaps();
    }

    public void onPossibleNetworkUpdateRequired() {
        if (!this.network.invalid && this.didNetworkChange()) {
            this.network.invalid = true;
        }
    }

    private boolean didNetworkChange() {
        for (Direction face : Direction.values()) {
            BlockPos checkPos = this.f_58858_.m_121945_(face);
            if (this.getNetwork().contains(this.f_58858_, face.m_122424_()) == this.getNetwork().isValidToBeInNetwork(checkPos, this.f_58857_, face.m_122424_())) continue;
            return true;
        }
        return false;
    }

    protected void tick() {
        this.mergeBuffer();
        if (!this.inventory.isEmpty()) {
            if (!this.f_58857_.f_46443_) {
                this.m_6596_();
            }
            LinkedList<ItemInTubeWrapper> remainingWrappers = new LinkedList<ItemInTubeWrapper>();
            for (ItemInTubeWrapper wrapper : this.inventory) {
                ++wrapper.ticksElapsed;
                if (wrapper.ticksElapsed >= wrapper.maximumDurationInTube) {
                    if (wrapper.freshlyInserted) {
                        wrapper.freshlyInserted = false;
                        wrapper.remainingMoves.removeFirst();
                        wrapper.ticksElapsed = 0;
                        remainingWrappers.add(wrapper);
                        continue;
                    }
                    this.sendWrapperOnward(wrapper);
                    continue;
                }
                remainingWrappers.add(wrapper);
            }
            this.inventory = remainingWrappers;
        }
        if (!this.f_58857_.f_46443_ && this.inventory.size() > (Integer)TubesReloaded.get().serverConfig().maxItemsInTube().get()) {
            this.f_58857_.m_7471_(this.f_58858_, false);
        }
    }

    public BlockPos getConnectedPos(Direction dir) {
        if (this.remoteConnections.containsKey(dir)) {
            return this.remoteConnections.get((Object)dir).toPos;
        }
        return this.f_58858_.m_121945_(dir);
    }

    public void sendWrapperOnward(ItemInTubeWrapper wrapper) {
        if (!wrapper.remainingMoves.isEmpty()) {
            Direction dir = wrapper.remainingMoves.poll();
            BlockPos nextPos = this.getConnectedPos(dir);
            BlockEntity nextBlockEntity = this.f_58857_.m_7702_(nextPos);
            if (nextBlockEntity instanceof TubeBlockEntity) {
                TubeBlockEntity nextTube = (TubeBlockEntity)nextBlockEntity;
                if (this.isTubeCompatible(nextTube) || this.hasRemoteConnection(nextPos)) {
                    nextTube.enqueueItemStack(wrapper.stack, wrapper.remainingMoves, wrapper.maximumDurationInTube);
                }
            } else if (!this.f_58857_.f_46443_) {
                if (nextBlockEntity != null) {
                    ItemStack remaining = nextBlockEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.m_122424_()).map(handler -> WorldHelper.disperseItemToHandler(wrapper.stack, handler)).orElse(wrapper.stack.m_41777_());
                    if (!remaining.m_41619_()) {
                        ItemStack unenqueueableItems = this.enqueueItemStack(remaining, dir, false);
                        WorldHelper.ejectItemstack(this.f_58857_, this.f_58858_, dir, unenqueueableItems);
                    }
                } else {
                    WorldHelper.ejectItemstack(this.f_58857_, this.f_58858_, dir, wrapper.stack);
                }
            }
        } else if (!this.f_58857_.f_46443_) {
            WorldHelper.ejectItemstack(this.f_58857_, this.f_58858_, null, wrapper.stack);
        }
    }

    public void onDataUpdated() {
        this.m_6596_();
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 3);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && side != null) {
            return this.handlerOptionals[side.ordinal()].cast();
        }
        return super.getCapability(cap, side);
    }

    public ItemStack enqueueItemStack(ItemStack stack, Direction face, boolean simulate) {
        Route route = this.getNetwork().getBestRoute(this.f_58857_, this.f_58858_, face, stack);
        if (route == null || route.sequenceOfMoves.isEmpty()) {
            return stack.m_41777_();
        }
        if (simulate) {
            return ItemStack.f_41583_;
        }
        int ticks_per_tube = this.getNetwork().getTicksPerTube();
        this.wrappersToSendToClient.add(new ItemInTubeWrapper(stack, route.sequenceOfMoves, ticks_per_tube, face.m_122424_()));
        this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        return this.enqueueItemStack(new ItemInTubeWrapper(stack, route.sequenceOfMoves, 10, face.m_122424_()));
    }

    public ItemStack enqueueItemStack(ItemInTubeWrapper wrapper) {
        this.incomingWrapperBuffer.add(wrapper);
        return ItemStack.f_41583_;
    }

    public ItemStack enqueueItemStack(ItemStack stack, Queue<Direction> remainingMoves, int ticksPerTube) {
        return this.enqueueItemStack(new ItemInTubeWrapper(stack, remainingMoves, ticksPerTube));
    }

    public void mergeBuffer() {
        if (!this.incomingWrapperBuffer.isEmpty()) {
            for (ItemInTubeWrapper wrapper : this.incomingWrapperBuffer) {
                this.inventory.add(wrapper);
            }
            this.incomingWrapperBuffer = new LinkedList<ItemInTubeWrapper>();
        }
    }

    public void dropItems() {
        this.mergeBuffer();
        for (ItemInTubeWrapper wrapper : this.inventory) {
            Containers.m_18992_((Level)this.f_58857_, (double)this.f_58858_.m_123341_(), (double)this.f_58858_.m_123342_(), (double)this.f_58858_.m_123343_(), (ItemStack)wrapper.stack);
        }
        this.inventory = new LinkedList<ItemInTubeWrapper>();
    }

    public static boolean isSpaceForAnythingInItemHandler(IItemHandler handler) {
        return true;
    }

    public boolean isAnyInventoryAdjacent() {
        for (Direction face : Direction.values()) {
            LazyOptional cap;
            IItemHandler handler;
            BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_121945_(face));
            if (te == null || te instanceof TubeBlockEntity || (handler = (IItemHandler)(cap = te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, face.m_122424_())).orElse(null)) == null || !TubeBlockEntity.isSpaceForAnythingInItemHandler(handler)) continue;
            return true;
        }
        return false;
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.readAllNBT(compound);
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.writeAllNBT(compound);
    }

    protected void writeAllNBT(CompoundTag compound) {
        BlockPos tubePos = this.m_58899_();
        BlockState state = this.m_58900_();
        OctahedralGroup group = (OctahedralGroup)state.m_61143_(TubeBlock.GROUP);
        OctahedralGroup normalizer = group.m_174944_();
        ListTag invList = new ListTag();
        this.mergeBuffer();
        for (ItemInTubeWrapper wrapper : this.inventory) {
            CompoundTag invTag = new CompoundTag();
            wrapper.writeToNBT(invTag, group);
            invList.add((Object)invTag);
        }
        if (!invList.isEmpty()) {
            compound.m_128365_(INV_NBT_KEY_RESET, (Tag)invList);
        }
        CompoundTag connectionsTag = new CompoundTag();
        this.remoteConnections.forEach((direction, connection) -> connectionsTag.m_128365_(normalizer.m_56528_(direction).m_122433_(), (Tag)connection.toStorage(tubePos).toNBT(group)));
        compound.m_128365_(CONNECTIONS, (Tag)connectionsTag);
    }

    protected void readAllNBT(@Nullable CompoundTag compound) {
        this.setConnectionSyncDirty(true);
        if (compound != null) {
            BlockState state = this.m_58900_();
            OctahedralGroup group = (OctahedralGroup)state.m_61143_(TubeBlock.GROUP);
            if (compound.m_128441_(INV_NBT_KEY_RESET)) {
                invList = compound.m_128437_(INV_NBT_KEY_RESET, 10);
                LinkedList<ItemInTubeWrapper> inventory = new LinkedList<ItemInTubeWrapper>();
                for (int i = 0; i < invList.size(); ++i) {
                    CompoundTag itemTag = invList.m_128728_(i);
                    inventory.add(ItemInTubeWrapper.readFromNBT(itemTag, group));
                }
                this.inventory = inventory;
            } else if (compound.m_128441_(INV_NBT_KEY_ADD)) {
                invList = compound.m_128437_(INV_NBT_KEY_ADD, 10);
                for (int i = 0; i < invList.size(); ++i) {
                    CompoundTag itemTag = invList.m_128728_(i);
                    this.inventory.add(ItemInTubeWrapper.readFromNBT(itemTag, group));
                }
            }
            if (compound.m_128441_(CONNECTIONS)) {
                CompoundTag connectionsTag = compound.m_128469_(CONNECTIONS);
                HashMap<Direction, RemoteConnection> newMap = new HashMap<Direction, RemoteConnection>();
                Direction[] dirs = Direction.values();
                for (int i = 0; i < 6; ++i) {
                    Direction dir = dirs[i];
                    String dirName = dir.m_122433_();
                    if (!connectionsTag.m_128441_(dirName)) continue;
                    CompoundTag connectionTag = connectionsTag.m_128469_(dirName);
                    RemoteConnection.Storage storage = RemoteConnection.Storage.fromNBT(connectionTag, group);
                    RemoteConnection connection2 = RemoteConnection.fromStorage(storage, dir, this.f_58858_);
                    newMap.put(group.m_56528_(dir), connection2);
                }
                this.remoteConnections = newMap;
            }
        }
        this.renderAABB = TubeBlockEntity.getAABBContainingConnectedPositions(this.f_58858_, this.remoteConnections.values().stream().map(connection -> connection.toPos).collect(Collectors.toSet()));
    }

    public CompoundTag m_5995_() {
        CompoundTag compound = super.m_5995_();
        this.setConnectionSyncDirty(true);
        this.writeAllNBT(compound);
        this.setConnectionSyncDirty(false);
        return compound;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.readAllNBT(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195642_((BlockEntity)this, be -> this.makeUpdatePacketTag());
    }

    protected CompoundTag makeUpdatePacketTag() {
        BlockState state = this.m_58900_();
        BlockPos pos = this.m_58899_();
        OctahedralGroup group = (OctahedralGroup)state.m_61143_(TubeBlock.GROUP);
        OctahedralGroup normalizer = group.m_174944_();
        CompoundTag compound = new CompoundTag();
        super.m_183515_(compound);
        ListTag invList = new ListTag();
        while (!this.wrappersToSendToClient.isEmpty()) {
            ItemInTubeWrapper wrapper = this.wrappersToSendToClient.poll();
            CompoundTag invTag = new CompoundTag();
            wrapper.writeToNBT(invTag, group);
            invList.add((Object)invTag);
        }
        if (!invList.isEmpty()) {
            compound.m_128365_(INV_NBT_KEY_ADD, (Tag)invList);
        }
        if (this.isConnectionSyncDirty()) {
            CompoundTag connectionsTag = new CompoundTag();
            this.remoteConnections.forEach((direction, connection) -> connectionsTag.m_128365_(normalizer.m_56528_(direction).m_122433_(), (Tag)connection.toStorage(pos).toNBT(group)));
            compound.m_128365_(CONNECTIONS, (Tag)connectionsTag);
            this.setConnectionSyncDirty(false);
        }
        return compound;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.readAllNBT(packet.m_131708_());
    }

    public void setConnectionsRaw(Map<Direction, RemoteConnection> newConnections) {
        this.remoteConnections = newConnections;
    }
}

