/*
 * Decompiled with CFR 0.152.
 */
package commoble.tubesreloaded.blocks.tube;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import commoble.tubesreloaded.ClientProxy;
import commoble.tubesreloaded.TubesReloaded;
import commoble.tubesreloaded.blocks.tube.SyncTubesInChunkPacket;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;

public class TubesInChunk
implements ICapabilityProvider,
INBTSerializable<CompoundTag> {
    public static final Capability<TubesInChunk> CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<TubesInChunk>(){});
    public static final Codec<Set<BlockPos>> TUBE_SET_CODEC = BlockPos.f_121852_.listOf().xmap(HashSet::new, ArrayList::new);
    public static final MapCodec<Set<BlockPos>> FIELD_CODEC = TUBE_SET_CODEC.fieldOf("positions");
    public static final Codec<Set<BlockPos>> CODEC = FIELD_CODEC.codec();
    private final LazyOptional<TubesInChunk> holder = LazyOptional.of(() -> this);
    private Set<BlockPos> positions = new HashSet<BlockPos>();
    private final LevelChunk chunk;

    public LevelChunk getChunk() {
        return this.chunk;
    }

    public TubesInChunk(LevelChunk chunk) {
        this.chunk = chunk;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CAPABILITY) {
            return CAPABILITY.orEmpty(cap, this.holder);
        }
        return LazyOptional.empty();
    }

    public Set<BlockPos> getPositions() {
        return this.positions;
    }

    public void setPositions(Set<BlockPos> set) {
        this.positions = set;
        TubesReloaded.CHANNEL.send(PacketDistributor.TRACKING_CHUNK.with(this::getChunk), (Object)new SyncTubesInChunkPacket(this.chunk.m_7697_(), set));
    }

    public CompoundTag serializeNBT() {
        return CODEC.encodeStart((DynamicOps)NbtOps.f_128958_, this.getPositions()).result().map(tag -> {
            CompoundTag compound;
            return tag instanceof CompoundTag ? (compound = (CompoundTag)tag) : null;
        }).orElseGet(CompoundTag::new);
    }

    public void deserializeNBT(CompoundTag nbt) {
        CODEC.decode((DynamicOps)NbtOps.f_128958_, (Object)nbt).result().map(Pair::getFirst).ifPresent(this::setPositions);
    }

    public static Set<ChunkPos> getRelevantChunkPositionsNearPos(BlockPos pos) {
        double range = (Double)TubesReloaded.get().serverConfig().maxTubeConnectionRange().get();
        ChunkPos chunkPos = new ChunkPos(pos);
        int chunkRange = (int)Math.ceil(range / 16.0);
        HashSet<ChunkPos> set = new HashSet<ChunkPos>();
        for (int xOff = -chunkRange; xOff <= chunkRange; ++xOff) {
            for (int zOff = -chunkRange; zOff <= chunkRange; ++zOff) {
                set.add(new ChunkPos(chunkPos.f_45578_ + xOff, chunkPos.f_45579_ + zOff));
            }
        }
        return set;
    }

    public static Set<BlockPos> getTubesInChunkIfLoaded(LevelAccessor level, ChunkPos chunkPos) {
        if (level.m_5776_()) {
            return ClientProxy.getTubesInChunk(chunkPos);
        }
        ChunkAccess chunkAccess = level.m_6522_(chunkPos.f_45578_, chunkPos.f_45579_, ChunkStatus.f_62326_, false);
        if (chunkAccess instanceof LevelChunk) {
            LevelChunk chunk = (LevelChunk)chunkAccess;
            return chunk.getCapability(CAPABILITY).map(TubesInChunk::getPositions).orElse(Set.of());
        }
        return Set.of();
    }

    public void onCapabilityInvalidated() {
        this.holder.invalidate();
    }
}

